import sys
import subprocess
import os


def main():
    # Convert wandb-style arguments (--argument=X) to Hydra-style (argument=X)
    args = []
    program = None
    for arg in sys.argv[1:]:
        if arg.startswith("--"):
            if "wandb_entity" in arg:
                # Skip wandb_entity argument
                continue
            if arg[2:9] == "program":
                program = arg[10:]
            else:
                args.append(arg[2:])  # Remove the leading '--'

        else:
            args.append(arg)

    wandb_entity = os.environ.get("WANDB_ENTITY")
    if wandb_entity is None:
        print("Error: WANDB_ENTITY environment variable is not set.")
        sys.exit(1)
    args.append("run.wandb_entity=" + wandb_entity)

    # Call the actual script with the modified arguments
    command = ["python", program] + args
    print(command)
    subprocess.run(command)


if __name__ == "__main__":
    main()
