# LCGNN

## Usage

### Preprocessing

We use a local graph clustering toolkit (https://github.com/kfoynt/LocalGraphClustering) to preprocess the graphs of OGB datasets. Specifically, we follow the `spectral_clustering.py` example in the toolkit to generate local clusters for each node of OGB datasets. 

### Training

Our code supports `NodePropDataset` and `LinkPropDataset` of OGB.
* Use `python train.py --dataset arxiv|products|papers` to train LCGNN for the node property prediction.
* Use `python train_gnn.py --dataset arxiv|products --model gcn/sage/gat` to train LCGNN-GCN/SAGE/GAT for the node property prediction.
* Use `python train_lp.py --dataset ppa|collab|citation` to train LCGNN for the link property prediction. 
* Use `python train_lp_gnn.py --dataset collab --model gcn/sage` to train LCGNN-GCN/SAGE for the link property prediction. 

## Dependency

The dependencies of the code are:
* scipy
* wandb
* torch, torchvision
* tensorboardX
* torch_geometric
* dgl
* ogb

