## Training OT-based GAN ##

#### Available Datasets ####
2D : Spiral, 8-Gaussian, 25-Gaussian, Checkerboard (25-Gaussian not implemented yet.)

Image : MNIST, CIFAR10, CelebA64, CelebA-HQ-256, LSUN-Church

#### Toy ####
Commands for toy experiments are as follows.
```
python train.py --dataset {spiral,8gaussian,25gaussian,checkerboard} --image_size 2 --nz 2 --model_name toy --tau 0.01 --lmbda 0 --num_iterations 30000 --beta1 {0,0.5} --save_content_every 5000 --save_ckpt_every 5000 --save_image_every 2000
```
#### CIFAR-10 ####
We train UOTM on CIFAR-10 using 4 32-GB V100 GPU. 
```
python train.py --exp {exp_name} --cost {w1,w2} --phi1 {linear,kl,chi,softplus} --phi2 {linear,kl,chi,softplus} --phi3 {linear,kl,chi,softplus} --model_name {ncsnpp,ddpm,otm} --ngf {64,128} --batch_size {64,128,256} --K_v {1,5} --K_T {1,5} --beta1 {0,0.5} --tau {0,0.001} --reg_name {r1,gp} --lmbda {0.2,2,10} {--use_ema}
```
WGAN-GP
```
python train.py --exp WGAN-GP --phi1 linear --phi2 linear --phi3 linear --model_name {ncsnpp,ddpm,otm} --batch_size {64,128,256} --beta1 0 --tau 0 --reg_name gp --lmbda 10 {--use_ema} {--lr_scheduler}
```
WGAN
```
python train.py --exp WGAN --phi1 linear --phi2 linear --phi3 linear --model_name {ncsnpp,ddpm,otm} --batch_size {64,128,256} --beta1 0 --tau 0 --reg_name none --clip 0.1 {--lr_scheduler}
```
OTM
```
python train.py --exp OTM --phi1 linear --phi2 linear --phi3 linear --model_name {ncsnpp,ddpm,otm} --batch_size {64,128,256} --beta1 0 --tau 0.001 --reg_name r1 --lmbda 0.2 {--use_ema} {--lr_scheduler}
```
UOTM
```
python train.py --exp UOTM --phi1 {kl,chi,softplus} --phi2 {kl,chi,softplus} --phi3 linear --model_name {ncsnpp,ddpm,otm} --batch_size {64,128,256} --beta1 0.5 --tau {0,0.001} --reg_name r1 --lmbda 0.2 {--use_ema} {--lr_scheduler}
```
UOTM-SD (cosine, linear)
```
python train.py --exp UOTM-SD-{cosine,linear} --phi1 softplus --phi2 softplus --phi3 linear --model_name ncsnpp --batch_size 256 --beta1 0.5 --tau 0.001 --reg_name r1 --lmbda 0.2 --use_ema --lr_scheduler --num_iterations 200000 --loss_scheduler {cosine, linear} --schedule_until 150000 --alpha_min 0.2 --alpha_max 5
```