class DPGraphGen_cora_Adam:
    def __init__(self):
        self.layer1_dim = 128
        self.layer2_dim = 32
        self.dec1_dim = 32
        self.dec2_dim = 64
        self.samp_num = 10
        self.delta = 1e-5
        self.eps_requirement = 1.0
        self.noise_sigma = 5.0
        self.batch_proc_size = 512
        self.grad_norm_max =  5
        self.C_decay = 0.99


class DPGraphGen_cora_ADADP:
    def __init__(self):
        self.layer1_dim = 128
        self.layer2_dim = 32
        self.dec1_dim = 32
        self.dec2_dim = 64
        self.samp_num = 10
        self.delta = 1e-5
        self.eps_requirement = 1.0
        self.noise_sigma = 5.0
        self.batch_proc_size = 512
        self.grad_norm_max =  5
        self.C_decay = 0.99
        self.tol = 1.0 # 'tolerance parameter'



class DPGraphGen_dblp2_Adam:
    def __init__(self):
        self.layer1_dim = 32
        self.layer2_dim = 16
        self.dec1_dim = 16
        self.dec2_dim = 32
        self.samp_num = 10
        self.delta = 1e-5
        self.eps_requirement = 1.0
        self.noise_sigma = 5.0
        self.batch_proc_size = 512
        self.grad_norm_max =  5
        self.C_decay = 0.99



class DPGraphGen_dblp2_ADADP:
    def __init__(self):
        self.layer1_dim = 32
        self.layer2_dim = 16
        self.dec1_dim = 16
        self.dec2_dim = 32
        self.samp_num = 10
        self.delta = 1e-5
        self.eps_requirement = 1.0
        self.noise_sigma = 5.0
        self.batch_proc_size = 512
        self.grad_norm_max =  5
        self.C_decay = 0.99
        self.tol = 1.0 # 'tolerance parameter'


class DPGraphGen_imdb_Adam:
    def __init__(self):
        self.layer1_dim = 32
        self.layer2_dim = 16
        self.dec1_dim = 16
        self.dec2_dim = 32
        self.samp_num = 10
        self.delta = 1e-5
        self.eps_requirement = 1.0
        self.noise_sigma = 5.0
        self.batch_proc_size = 512
        self.grad_norm_max = 5
        self.C_decay = 0.99


class DPGraphGen_imdb_ADADP:
    def __init__(self):
        self.layer1_dim = 32
        self.layer2_dim = 16
        self.dec1_dim = 16
        self.dec2_dim = 32
        self.samp_num = 10
        self.delta = 1e-5
        self.eps_requirement = 1.0
        self.noise_sigma = 5.0
        self.batch_proc_size = 512
        self.grad_norm_max = 5
        self.C_decay = 0.99
        self.tol = 1.0  # 'tolerance parameter'


class GraphGen_cora:
    def __init__(self):
        self.layer1_dim = 128
        self.layer2_dim = 32
        self.dec1_dim = 32
        self.dec2_dim = 64
        self.samp_num = 10


class GraphGen_dblp2:
    def __init__(self):
        self.layer1_dim = 128
        self.layer2_dim = 32
        self.dec1_dim = 32
        self.dec2_dim = 64
        self.samp_num = 10


class GraphGen_imdb:
    def __init__(self):
        self.layer1_dim = 128
        self.layer2_dim = 32
        self.dec1_dim = 32
        self.dec2_dim = 64
        self.samp_num = 10



def load_config(model_name, dataset_str, optimizer):
    if model_name == 'GraphGen' and dataset_str == 'cora':
        return GraphGen_cora()
    elif model_name == 'GraphGen' and dataset_str == 'dblp2':
        return GraphGen_dblp2()
    elif model_name in ['GraphGen', 'GraphVAE'] and dataset_str in ['Resampled_IMDBMULTI', 'new_IMDB_MULTI', 'IMDB_MULTI']:
        return GraphGen_imdb()
    elif model_name == 'DPGraphGen' and dataset_str == 'cora' and optimizer == 'ADADP':
        return DPGraphGen_cora_ADADP()
    elif model_name == 'DPGraphGen' and dataset_str == 'cora' and optimizer == 'Adam':
        return DPGraphGen_cora_Adam()
    elif model_name == 'DPGraphGen' and dataset_str == 'dblp2' and optimizer == 'ADADP':
        return DPGraphGen_dblp2_ADADP()
    elif model_name == 'DPGraphGen' and dataset_str == 'dblp2' and optimizer == 'Adam':
        return DPGraphGen_dblp2_Adam()
    elif model_name in ['DPGraphGen', 'DPGraphVAE'] and dataset_str in ['Resampled_IMDBMULTI', 'new_IMDB_MULTI', 'IMDB_MULTI'] and optimizer == 'ADADP':
        return DPGraphGen_imdb_ADADP()
    elif model_name in ['DPGraphGen', 'DPGraphVAE'] and dataset_str in ['Resampled_IMDBMULTI', 'new_IMDB_MULTI', 'IMDB_MULTI'] and optimizer == 'Adam':
        return DPGraphGen_imdb_Adam()
