import numpy as np
import matplotlib.pyplot as plt
if __name__ == '__main__':
    data = np.load('tmix_data.npy')
    wang_plot = []
    tmix_list = np.linspace(10, 1000,10)
    for tmix in tmix_list:
        temp = np.array([data[i] for i in range(len(data)) if data[i][1]==tmix])
        to_append = [temp[:,2]@temp[:,4]/300,temp[:,3]@temp[:,4]/300,tmix]
        wang_plot.append(to_append)
    
    wang_plot = np.array(wang_plot)
    wang_plot[:,1] = wang_plot[:,1]-0.5
    
    plt.rcParams["figure.figsize"] = (6.5,4.5)
    plt.rcParams.update({'font.size': 18})
    plt.rcParams['font.family'] = 'serif'
    plt.tick_params(axis='both', which='major', labelsize=16)
    plt.rc('legend',fontsize=13)
    plt.ylim(0.001, 0.02)
    plt.xscale('log', base=10)
    plt.yscale('log', base=10)
    plt.grid(True, which="both", linestyle='--', linewidth=0.5)
    
    # #c = ['tab:blue','tab:red','tab:green']
    
    # slope, intercept = np.polyfit(np.log10(jin_plot[:,0]), np.log10(jin_plot[:,1]), 1)
    # regression_line = 10**(slope * np.log10(jin_plot[:,0]) + intercept)
    # plt.scatter(jin_plot[:,0],jin_plot[:,1],c='tab:blue',label =f'[J&S21], slope = {slope:.2f}')
    # plt.plot(jin_plot[:,0],regression_line, linestyle='--',c='tab:blue')
    
    slope, intercept = np.polyfit(np.log10(wang_plot[:,2]), np.log10(wang_plot[:,1]), 1)
    regression_line = 10**(slope * np.log10(wang_plot[:,2]) + intercept)
    plt.scatter(wang_plot[:,2],wang_plot[:,1],c ='mediumblue')
    plt.plot(wang_plot[:,2],regression_line, linestyle='--',c='mediumblue',label =f'slope = {slope:.2f}')
    
    
    data = np.load('tmix_data_0.1.npy')
    wang_plot = []
    tmix_list = np.linspace(10, 1000,10)
    for tmix in tmix_list:
        temp = np.array([data[i] for i in range(len(data)) if data[i][1]==tmix])
        to_append = [temp[:,2]@temp[:,4]/300,temp[:,3]@temp[:,4]/300,tmix]
        wang_plot.append(to_append)
    
    wang_plot = np.array(wang_plot)
    wang_plot[:,1] = wang_plot[:,1]-0.5
    
    slope, intercept = np.polyfit(np.log10(wang_plot[:,2]), np.log10(wang_plot[:,1]), 1)
    regression_line = 10**(slope * np.log10(wang_plot[:,2]) + intercept)
    plt.scatter(wang_plot[:,2],wang_plot[:,1],c='darkviolet')
    plt.plot(wang_plot[:,2],regression_line, linestyle='--',c='darkviolet',label =f'slope = {slope:.2f}')
    
    plt.xlabel("$t_{minorize}$")
    plt.ylabel("average error")
    plt.legend(loc='upper right')
    plt.tight_layout()
    plt.savefig('tmix_test', dpi=800)