BASE_MODEL_PATH = 'redacted'

models = {
        'internlm2-base-20b': {
            'hf': 'internlm/internlm2-base-20b',
            'GPU_MEM': 45000,
            'INF_MEM': 45000,
            'per_device_eval_batch_size': 8,
            'per_device_train_batch_size': 8,
            'JOB_GPUS': 8,
            'lr': 2e-6,
            'gradient_checkpointing': True,
            'isnew': True,
        },
        'internlm-20b': {
            'hf': 'internlm/internlm-20b',
            'GPU_MEM': 45000,
            'INF_MEM': 45000,
            'per_device_eval_batch_size': 8,
            'per_device_train_batch_size': 8,
            'JOB_GPUS': 8,
            'lr': 2e-6,
            'gradient_checkpointing': True,
            'isnew': True,
        },
        'llama-30b': {
            'hf': 'huggyllama/llama-30b',
            'GPU_MEM': 45000,
            'INF_MEM': 45000,
            'per_device_eval_batch_size': 8,
            'per_device_train_batch_size': 8,
            'JOB_GPUS': 8,
            'INF_GPUS': 2,
            'lr': 2e-6,
            'gradient_checkpointing': True,
            'isnew': False,
        },
        'qwen-1.5-14b': {
            'hf': 'Qwen/Qwen1.5-14B',
            'GPU_MEM': 45000,
            'INF_MEM': 45000,
            'per_device_eval_batch_size': 8,
            'per_device_train_batch_size': 8,
            'JOB_GPUS': 4,
            'lr': 2e-6,
            'gradient_checkpointing': True,
            'isnew': True,
        },
        'ziya2-13b-base': {
            'hf': 'IDEA-CCNL/Ziya2-13B-Base',
            'GPU_MEM': 45000,
            'INF_MEM': 39000,
            'per_device_eval_batch_size': 16,
            'per_device_train_batch_size': 16,
            'JOB_GPUS': 4,
            'lr': 2e-6,
            'gradient_checkpointing': True,
            'isnew': True,
        },
        'skywork-13b': {
            'hf': 'Skywork/Skywork-13B-base',
            'GPU_MEM': 45000,
            'INF_MEM': 45000,
            'per_device_eval_batch_size': 16,
            'per_device_train_batch_size': 16,
            'JOB_GPUS': 4,
            'lr': 2e-6,
            'gradient_checkpointing': True,
            'isnew': True,
        },
        'baichuan2-13b': {
            'hf': 'baichuan-inc/Baichuan2-13B-Base',
            'GPU_MEM': 45000,
            'INF_MEM': 39000,
            'per_device_eval_batch_size': 16,
            'per_device_train_batch_size': 16,
            'JOB_GPUS': 4,
            'lr': 2e-6,
            'gradient_checkpointing': True,
            'isnew': True,
        },
        'baichuan-13b': {
            'hf': 'baichuan-inc/Baichuan-13B-Base',
            'GPU_MEM': 45000,
            'INF_MEM': 39000,
            'per_device_eval_batch_size': 16,
            'per_device_train_batch_size': 16,
            'JOB_GPUS': 4,
            'lr': 2e-6,
            'gradient_checkpointing': True,
            'isnew': True,
        },
        'llama-2-13b': {
            'hf': 'meta-llama/Llama-2-13b-hf',
            'GPU_MEM': 45000,
            'INF_MEM': 39000,
            'per_device_eval_batch_size': 16,
            'per_device_train_batch_size': 16,
            'JOB_GPUS': 4,
            'lr': 2e-6,
            'gradient_checkpointing': True,
            'isnew': False,
        },
        'llama-13b': {
            'hf': 'yahma/llama-13b-hf',
            'GPU_MEM': 45000,
            'INF_MEM': 45000,
            'per_device_eval_batch_size': 16,
            'per_device_train_batch_size': 16,
            'JOB_GPUS': 4,
            'lr': 2e-6,
            'gradient_checkpointing': True,
            'isnew': False,
        },
        'falcon-11b': {
            'hf': 'tiiuae/falcon-11B',
            'GPU_MEM': 45000,
            'INF_MEM': 45000,
            'per_device_eval_batch_size': 16,
            'per_device_train_batch_size': 16,
            'JOB_GPUS': 4,
            'lr': 2e-6,
            'gradient_checkpointing': True,
            'isnew': True,
        },
        'pythia-12b': {
            'hf': 'EleutherAI/pythia-12b',
            'GPU_MEM': 45000,
            'INF_MEM': 39000,
            'per_device_eval_batch_size': 16,
            'per_device_train_batch_size': 16,
            'JOB_GPUS': 4,
            'lr': 2e-6,
            'gradient_checkpointing': True,
            'isnew': False,
        },
        'openllama-13b': {
            'hf': 'openlm-research/open_llama_13b',
            'GPU_MEM': 45000,
            'INF_MEM': 45000,
            'per_device_eval_batch_size': 16,
            'per_device_train_batch_size': 16,
            'JOB_GPUS': 4,
            'lr': 2e-6,
            'gradient_checkpointing': True,
            'isnew': False,
        },
        'stablelm-2-12b': {
            'hf': 'stabilityai/stablelm-2-12b',
            'GPU_MEM': 45000,
            'INF_MEM': 39000,
            'per_device_eval_batch_size': 16,
            'per_device_train_batch_size': 16,
            'JOB_GPUS': 4,
            'lr': 2e-6,
            'gradient_checkpointing': True,
            'isnew': True,
        },
        'internlm2-base-7b': {
            'hf': 'internlm/internlm2-base-7b',
            'GPU_MEM': 91000,
            'INF_MEM': 20000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': True,
        },
        'internlm-7b': {
            'hf': 'internlm/internlm-7b',
            'GPU_MEM': 91000,
            'INF_MEM': 20000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': True,
        },
        'baichuan-7b': {
            'hf': 'baichuan-inc/Baichuan2-7B-Base',
            'GPU_MEM': 91000,
            'INF_MEM': 20000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': True,
        },
        'falcon-7b': {
            'hf': 'tiiuae/falcon-7b',
            'GPU_MEM': 91000,
            'INF_MEM': 20000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': False,
        },
        'llama-3-8b': {
            'hf': 'meta-llama/Meta-Llama-3-8B',
            'GPU_MEM': 91000,
            'INF_MEM': 39000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': True,
        },
        'gemma-7b': {
            'hf': 'google/gemma-7b',
            'GPU_MEM': 91000,
            'INF_MEM': 39000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 0.5,
            'lr': 2e-6,
            'isnew': True,
        },
        'pythia-70m': {
            'hf': 'EleutherAI/pythia-70m',
            'GPU_MEM': 39000,
            'INF_MEM': None,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': False,
        },
        'gemma-2b': {
            'hf': 'google/gemma-2b',
            'GPU_MEM': 45000,
            'INF_MEM': 20000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': True,
        },
        'olmo-1b': {
            'hf': 'allenai/OLMo-1B-hf',
            'GPU_MEM': 45000,
            'INF_MEM': 20000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': True,
        },
        'stablelm-2-1.6b': {
            'hf': 'stabilityai/stablelm-2-1_6b',
            'GPU_MEM': 45000,
            'INF_MEM': 20000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': True,
        },
        'redpajama-3b': {
            'hf': 'togethercomputer/RedPajama-INCITE-Base-3B-v1',
            'GPU_MEM': 45000,
            'INF_MEM': 20000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': False,
        },
        'pythia-160m': {
            'hf': 'EleutherAI/pythia-160m',
            'GPU_MEM': 39000,
            'INF_MEM': None,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': False,
        },
        'pythia-410m': {
            'hf': 'EleutherAI/pythia-410m',
            'GPU_MEM': 39000,
            'INF_MEM': None,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': False,
        },
        'pythia-1b': {
            'hf': 'EleutherAI/pythia-1b',
            'GPU_MEM': 45000,
            'INF_MEM': 20000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': False,
        },
        'pythia-1.4b': {
            'hf': 'EleutherAI/pythia-1.4b',
            'GPU_MEM': 45000,
            'INF_MEM': 20000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': False,
        },
        'pythia-2.8b': {
            'hf': 'EleutherAI/pythia-2.8b',
            'GPU_MEM': 45000,
            'INF_MEM': 20000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': False,
        },
        'openllama-3b': {
            'hf': 'openlm-research/open_llama_3b',
            'GPU_MEM': 45000,
            'INF_MEM': 20000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': False,
        },
        'openllama-3b-v2': {
            'hf': 'openlm-research/open_llama_3b_v2',
            'GPU_MEM': 45000,
            'INF_MEM': 20000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': False,
        },
        'stablelm-base-alpha-3b-v2': {
            'hf': 'stabilityai/stablelm-base-alpha-3b-v2',
            'GPU_MEM': 45000,
            'INF_MEM': 20000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': False,
        },
        'stablelm-3b-4e1t': {
            'hf': 'stabilityai/stablelm-3b-4e1t',
            'GPU_MEM': 45000,
            'INF_MEM': 20000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': False,
        },
        'llama-2-7b': {
            'hf': 'meta-llama/Llama-2-7b-hf',
            'GPU_MEM': 91000,
            'INF_MEM': 20000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': False,
        },
        'llama-7b': {
            'hf': 'luodian/llama-7b-hf',
            'GPU_MEM': 91000,
            'INF_MEM': 20000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': False,
        },
        'olmo-7b': {
            'hf': 'allenai/OLMo-7B-hf',
            'GPU_MEM': 91000,
            'INF_MEM': 45000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': True,
        },
         'stablelm-base-alpha-7b-v2': {
            'hf': 'stabilityai/stablelm-base-alpha-7b-v2',
            'GPU_MEM': 91000,
            'INF_MEM': 45000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': False,
        },
        'redpajama-7b': {
            'hf': 'togethercomputer/RedPajama-INCITE-7B-Base',
            'GPU_MEM': 45000,
            'INF_MEM': 20000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': False,
        },
        'pythia-6.9b': {
            'hf': 'EleutherAI/pythia-6.9b',
            'GPU_MEM': 45000,
            'INF_MEM': 20000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': False,
        },
        'gpt-j-6b': {
            'hf': 'EleutherAI/gpt-j-6b',
            'GPU_MEM': 45000,
            'INF_MEM': 45000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': False,
        },
        'openllama-7b': {
            'hf': 'openlm-research/open_llama_7b',
            'GPU_MEM': 90000,
            'INF_MEM': 39000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': False,
        },
        'openllama-7b-v2': {
            'hf': 'openlm-research/open_llama_7b_v2',
            'GPU_MEM': 90000,
            'INF_MEM': 39000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': False,
        },
        'olmo-1.7-7b': {
            'hf': 'allenai/OLMo-1.7-7B-hf',
            'GPU_MEM': 45000,
            'INF_MEM': 45000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': True,
        },
        'qwen-1.5-0.5b': {
            'hf': 'Qwen/Qwen1.5-0.5B',
            'GPU_MEM': 39000,
            'INF_MEM': 45000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': True,
        },
        'qwen-1.5-1.8b': {
            'hf': 'Qwen/Qwen1.5-1.8B',
            'GPU_MEM': 45000,
            'INF_MEM': 45000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': True,
        },
        'qwen-1.5-4b': {
            'hf': 'Qwen/Qwen1.5-4B',
            'GPU_MEM': 45000,
            'INF_MEM': 45000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': True,
        },
        'qwen-1.5-7b': {
            'hf': 'Qwen/Qwen1.5-7B',
            'GPU_MEM': 91000,
            'INF_MEM': 45000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': True,
        },
        'yi-6b': {
            'hf': '01-ai/Yi-1.5-6B',
            'GPU_MEM': 91000,
            'INF_MEM': 45000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': True,
        },
        'baichuan2-7b': {
            'hf': 'baichuan-inc/Baichuan2-7B-Base',
            'GPU_MEM': 91000,
            'INF_MEM': 39000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': True,
        },
        'map-neo-7b': {
            'hf': 'm-a-p/neo_7b',
            'GPU_MEM': 91000,
            'INF_MEM': 20000,
            'per_device_eval_batch_size': 1,
            'per_device_train_batch_size': 1,
            'lr': 2e-5,
            'isnew': True,
        },
        'llama-2-70b': {
            'hf': 'meta-llama/Llama-2-70b-hf',
            'GPU_MEM': 45000,
            'INF_MEM': 45000,
            'per_device_eval_batch_size': 4,
            'per_device_train_batch_size': 4,
            'JOB_GPUS': 8,
            'INF_GPUS': 3,
            'gradient_checkpointing': True,
            'N_NODES': 2,
            'lr': 2e-6,
            'isnew': False,
         },
         'llama-65b': {
            'hf': 'huggyllama/llama-65b',
            'GPU_MEM': 45000,
            'INF_MEM': 45000,
            'per_device_eval_batch_size': 4,
            'per_device_train_batch_size': 4,
            'JOB_GPUS': 8,
            'INF_GPUS': 3,
            'gradient_checkpointing': True,
            'N_NODES': 2,
            'lr': 2e-6,
            'isnew': False,
         },
}

# add model_path to every model
for model in models:
    models[model]['model_path'] = BASE_MODEL_PATH + model

def get_model_name(model_dir):
    for model in models.keys():
        if model in model_dir:
            return model
    return None

def get_job_memory(model_dir):
    model_name = get_model_name(model_dir)
    if model_name in models:
        return models[model_name]['INF_MEM']
    return 90000  # default to max

def get_n_gpus(model):
    model_name = get_model_name(model)
    if model_name in models:
        if 'INF_GPUS' in models[model_name]:
            return models[model_name]['INF_GPUS']
    return 1
