import argparse

def parse_args():
    parser = argparse.ArgumentParser(description='KGQA 参数配置')

    # GPU 相关参数
    parser.add_argument('--gpu', type=str, default="0", help='指定使用的 GPU ID (默认: 0)')
    parser.add_argument('--debug', default=False, action="store_true", help='是否为调试模式 (默认: False)')
    parser.add_argument('--resume', type=str, default=None, help='恢复训练的模型路径')
    parser.add_argument('--config', type=str, default=None, help='配置名称')
    # GPU wait
    parser.add_argument('--gpu-wait-interval', type=int, default=60, help='GPU 等待间隔')
    parser.add_argument('--gpu-wait-counts', type=int, default=5, help='GPU 等待连续次数')
    parser.add_argument('--gpu-wait-threshold', type=int, default=10000, help='GPU 等待内存阈值')
    parser.add_argument('--nowait', default=False, action="store_true", help='是否不等待 GPU (默认: False)')
    args = parser.parse_args()
    return args

if __name__ == '__main__':
    args = parse_args()
    print(f"使用 GPU ID: {args.gpu}")