#!/bin/bash

# rsync -avL --exclude={".venv",".env","*.lock","*.pyc"} --progress . zwj@172.19.13.4:/data/zwj/KGQA/
# rsync -avL --exclude={".venv",".env","*.lock","*.pyc","checkpoint-*"} --progress ckpt/bge-reranker-v2-m3-0702-10 zwj@172.19.13.4:/data/zwj/KGQA/ckpt/bge-reranker-v2-m3-0702-10
# rsync -avL --exclude={".venv",".env","*.lock","*.pyc","checkpoint-*"} --progress ckpt/bge-reranker-v2-m3-0702-10 zwj@172.18.232.252:/home/zwj/workspace/KGQA/ckpt/bge-reranker-v2-m3-0702-10
# /home/zwj/workspace/KGQA

set -e

# 解析参数
SYNC_DIR="."
IP=""

# 处理命令行参数
while [[ $# -gt 0 ]]; do
    case $1 in
        -d|--dir)
            SYNC_DIR="$2"
            shift 2
            ;;
        *)
            # 如果不是选项，则认为是IP地址
            if [[ -z "$IP" ]]; then
                IP="$1"
            fi
            shift
            ;;
    esac
done

# 如果没有提供IP地址，使用默认值
IP=${IP:-172.19.13.4}

# 检查指定的目录是否存在
if [[ ! -d "$SYNC_DIR" ]]; then
    echo "错误：目录 '$SYNC_DIR' 不存在"
    exit 1
fi

# 根据同步目录调整目标路径
if [[ "$SYNC_DIR" == "." ]]; then
    # 同步整个项目
    TARGET_PATH="zwj@$IP:/data/zwj/KGQA"
    echo "正在同步整个项目到 $IP..."
else
    # 同步指定文件夹
    TARGET_PATH="zwj@$IP:/data/zwj/KGQA/"
    echo "正在同步目录 '$SYNC_DIR' 到 $IP..."
fi

rsync -avL --exclude={".venv",".env","*.lock","*.pyc"} --progress "$SYNC_DIR" "$TARGET_PATH"
