# 初始化并激活 conda 环境的正确方式
source ~/anaconda3/etc/profile.d/conda.sh  # 或者 source ~/.conda/etc/profile.d/conda.sh
conda activate llm

# echo "第1步：生成重排序数据..."
# python -m src.generate_neg \
#     --input_file "data/RoG-webqsp-valid-paths.jsonl" \
#     --output_file "data/RoG-webqsp-valid_rerank_test.jsonl"
CUDA_VISIBLE_DEVICES=0

echo "第2步：评估本地模型..."
python eval_rerank.py \
    --model_path "ckpt/bge-reranker-v2-m3" \
    --data_file "data/RoG-webqsp-valid_rerank_test.jsonl"

wait

echo "第3步：评估HuggingFace模型..."
python eval_rerank.py \
    --model_path "/data/public/models/BAAI/bge-reranker-v2-m3" \
    --data_file "data/RoG-webqsp-valid_rerank_test.jsonl"

wait

# 使用大模型获取最新的有效路径
python -m src.scripts.get_valid_paths \
    --dataset cwq \
    --data_path /hdd/zwj/hf_datasets/rmanluo/RoG-cwq \
    --output_dir ./data/cwq \
    --split test \
    --max_paths 300 \
    --model qwen3-32b


# 基于有效路径构造 Memory
python -m src.memory \
    --dataset-name webqsp \
    --path-type valid \
    --embed-model bge-m3 \
    --valid-path-file "data/webqsp/RoG-webqsp.train.valid.jsonl"

# 使用 Memory 进行推理并获得推理结果
python main.py

# 退出 conda 环境
conda deactivate