MCQ_INSTRUCTION = """
Please answer the following questions.
Please select the answers from the given choices and return the answer only.
"""

SAQ_INSTRUCTION = """
Please answer the following questions.
Please keep the answer as simple as possible and return all the possible answer as a list.
"""

FID_PLAN_INSTRUCTION = """
You are a helpful assistant designed to output JSON that aids in
 navigating a knowledge graph to answer a provided question.
The response should include the following keys:
(1) 'keywords': an exhaustive list of keywords or relation names that you would use to find the reasoning path
 from the knowledge graph to answer the question.
Aim for maximum coverage to ensure no potential reasoning paths will be overlooked;
(2) 'planning_steps': a list of detailed steps required to trace the reasoning path with.
Each step should be a string instead of a dict.
(3) 'declarative_statement': a string of declarative statement that can be transformed from the given query,
For example, convert the question 'What do Jamaican people speak?' into the statement 'Jamaican people speak *placeholder*.'
leave the *placeholder* unchanged; Ensure the JSON object clearly separates these components.

Q: {question}
A:
"""

INITIAL_INSTRUCTION = """
You are a helpful assistant designed to output JSON that aids in
 navigating a knowledge graph to answer a provided question.
The response should include the following keys:

(1) reasoning_paths: List[str], a list of reasoning steps that should be used to answer the question. format like {rel_path_example}.
(2) candidate_answers: List[str], a list of candidate answers that may be used to answer the question, answers should be simple and specific as an Entity.

Q: {question}, {q_entity}
A:
"""


INITIAL_INSTRUCTION_WITH_SAMPLES = """
You are a helpful assistant designed to output JSON that aids in
 navigating a knowledge graph to answer a provided question.
The response should include the following keys:

(1) reasoning_paths: List[str], a list of reasoning steps that should be used to answer the question.
(2) candidate_answers: List[str], a list of candidate answers that may be used to answer the question, answers should be simple and specific as an Entity.

---

{samples}

---

Q: {question}, {q_entity}
A:
"""

FID_DEDUCTIVE_INSTRUCTION = """
You are asked to verify whether the reasoning step follows deductively from the question and the current reasoning path in a deductive manner.
If yes return yes, if no, return no.
Whether the conclusion '{declarative_statement}' can be deduced from '{parsed_reasoning_paths}', if yes, return yes, if no, return no.
A:
"""

FID_SUFFICIENT_INSTRUCTION = """
You are asked to verify whether it's sufficient for you to answer the question with the following reasoning path.
For each reasoning path, respond with 'Yes' if it is sufficient, and 'No' if it is not. Your response should be either 'Yes' or 'No'.
Whether the reasoning path '{reasoning_paths}' be sufficient to answer the query '{Query}', if yes, return 'Yes', if no, return 'No'.
A:
"""

FINAL_INSTRUCTION = """
You are a helpful assistant designed to output JSON that aids in using the provided question and the reasoning paths from a knowledge graph,
give the answer (a node) based on the reasoning paths and your knowledge.

The JSON format response should include the following keys:
(1) possible_answers: List[str], all possible answers to the question.
(2) most_possible_answer: str, the most possible answer to the question.

Reasoning paths: {reasoning_paths}
Question: {query}

Answer:
"""

#! FINAL_INSTRUCT_WITH_AGENT
FINAL_INSTRUCT_WITH_AGENT = """
You are a helpful assistant designed to output JSON that aids in using the provided question and the reasoning paths from a knowledge graph,
give the answer (a node) based on the reasoning paths and your knowledge.
If you cannot find the related nodes, please give the possible answers based on your knowledge.

The JSON format response should include the following keys:
(1) possible_answers: List[str], all possible answers to the question.
(2) most_possible_answer: str, the most possible answer to the question.

Reasoning paths: {reasoning_paths}
Question: {question}

Answer:
"""

FINAL_INSTRUCT_WITH_AGENT_WITH_SAMPLE = """
You are a helpful assistant designed to output JSON that aids in using the provided question and the reasoning paths from a knowledge graph,
you can think about the question and the reasoning paths carefully,
and give the answer (a node) based on the reasoning paths and your knowledge.

REMEMBER:
(1) ONLY when you cannot find possible answers based on those paths, you can use the tools to find the possible answers.
(2) If the tools cannot find the possible answers, you can use your knowledge to find the possible answers.
(3) You have to give the possible answers based on the previous tools result, reasoning paths and your knowledge.
(4) IF the answer ENTITY is in the context(tools result, reasoning paths), you have to give the answer the same as the context.

The JSON format response should include the following keys:
(1) possible_answers: List[str], all possible answers to the question.
(2) most_possible_answer: str, the most possible answer to the question (CANNOT be empty).

===
Here are some examples of the question and the reasoning paths:

{samples}

===

Reasoning paths: {reasoning_paths}
Question: {question}

Answer:
"""

FINAL_INSTRUCTION_WITH_SAMPLE = """
You are a helpful assistant designed to output JSON that aids in using the provided question and the reasoning paths from a knowledge graph,
give the answer (a node) based on the reasoning paths and your knowledge.

limits:
1. if the answer is date with month and day, return the date in the format of YYYY-MM-DD

---

some examples

{samples}

---


The JSON format response should include the following keys:
(1) possible_answers: List[str], all possible answers to the question.
(2) most_possible_answer: str, the most possible answer to the question.

Reasoning paths: {reasoning_paths}
Question: {query}

Answer:
"""

FINAL_INSTRUCTION_WITH_TRIPLES = """You are a helpful assistant designed to output JSON that aids in using the provided question and the reasoning paths from a knowledge graph,
give the answer (a node) based on the reasoning paths and your knowledge.

The JSON format response should include the following keys:
(1) possible_answers: List[str], all possible answers to the question.
(2) most_possible_answer: str, the most possible answer to the question.

Reasoning paths: {reasoning_paths}
Additional Knowledge:
{additional_triples}

Question: {query}

Answer:
"""

ROG_FINAL_INSTRUCTION = """
Based on the reasoning paths, please answer the given question. Please keep the answer as simple as possible and return all the possible answers as a list.

Reasoning paths: {reasoning_paths}

Question: {query}

Answer:
"""

COT_FINAL_INSTRUCTION = """
You are a highly effective assistant, designed to utilize the provided question and reasoning paths from a knowledge graph to generate outputs that facilitate problem - solving. Based on these reasoning paths and your own knowledge, you are required to provide the answer (a node).

You must adhere to the following workflow definition:

[Planning] Break down the process of answering the question into as few sub-objectives as possible based on semantic analysis. List of detailed steps required to trace the reasoning path with.

[Initial thinking with smallest step] To answer the question, I initially need to know <information>.

[Step - by - step thinking]: According to the reasoning path above, the <information> is <INF>.
Now, can I answer the question based on our internal thought process?
- Yes, the answer is <Answer>. [Action: To Reflection]
- No, I have to know the <next - information>.  [Action: Repeat this thinking step]
- NA, there is no more information to answer this question, use inner knowledge. [Action: To Answer]

[Step - by - step thinking] [if NO]: According to the reasoning path above, the <information> is <INF>.
Now, can I answer the question based on our internal thought process?
- Yes, the answer is <Answer>. [Action: To Reflection]
- No, I have to know the <next - information>.  [Action: Repeat this thinking step]
- NA, there is no more information to answer this question, use inner knowledge. [Action: To Answer]

[Reflection]
Based on ABOVE thinking steps, is this the right way to think and us these answer correct?
- Yes, I am sure that the previous thinking process nad the answer is correct. [Action: To Answer]
- No, maybe I should rethink the previous content. [Action: To step - by - setp thinking]
...

Finally, the answers are: Answer1, Answer2

Reasoning Paths: {reasoning_path}
Question: {question}
Answer:
"""

def build_prompt(type, **opts):
    if type == "mcq":
        question = opts["question"]
        choices = opts["choices"]
        return MCQ_INSTRUCTION + "\n" + question + "\n" + "\n".join(choices)

    elif type == "saq":
        question = opts["question"]
        return SAQ_INSTRUCTION + "\n" + question

    elif type == "fid":
        question = opts["question"]
        return FID_PLAN_INSTRUCTION.format(question=question)

    elif type == "initial":
        question = opts["question"]
        dataset_name = opts["dataset_name"]
        q_entity = opts["q_entity"]
        rel_path_example = REL_PATH_EXAMPLE[dataset_name]
        return INITIAL_INSTRUCTION.format(question=question, q_entity=q_entity, rel_path_example=rel_path_example)

    elif type == "initial_with_samples":
        question = opts["question"]
        dataset_name = opts["dataset_name"]
        q_entity = opts["q_entity"]
        samples = opts["samples"]
        return INITIAL_INSTRUCTION_WITH_SAMPLES.format(question=question, q_entity=q_entity, samples=samples)

    elif type == "final":
        question = opts["question"]
        reasoning_paths = opts["reasoning_paths"]
        return FINAL_INSTRUCTION.format(query=question, reasoning_paths=reasoning_paths)

    elif type == "final_with_samples":
        question = opts["question"]
        reasoning_paths = opts["reasoning_paths"]
        samples = opts["samples"]
        return FINAL_INSTRUCTION_WITH_SAMPLE.format(query=question, reasoning_paths=reasoning_paths, samples=samples)

    elif type == "final_with_triples":
        question = opts["question"]
        reasoning_paths = opts["reasoning_paths"]
        additional_triples = opts["additional_triples"]
        return FINAL_INSTRUCTION_WITH_TRIPLES.format(query=question, reasoning_paths=reasoning_paths, additional_triples=additional_triples)

    elif type == "rog_final":
        question = opts["question"]
        reasoning_paths = opts["reasoning_paths"]
        return ROG_FINAL_INSTRUCTION.format(query=question, reasoning_paths=reasoning_paths)

    else:
        raise ValueError("Invalid prompt type")

REL_PATH_EXAMPLE = {
    "webqsp": [
        "<START> --base.locations.states_and_provences.country--> <node> --people.person.nationality--> <ANSWER>",
        "<START> --government.us_president.vice_president--> <ANSWER>"
    ],
}