# MLRPTM

## Usage

Train for CIFAR-10 dataset:
```
python train.py \
    --lr 1e-7 \
    --lambda_task 0.2 \
    --lambda_scatter 0.8 \
    --lambda_mse 0.2 \
    --first_bn_mul 10.0 \
    --BatchSize 64 \
    --epochs 50 \
    --num_instances 32 \
    --batch_size_gen 16 \
    --num_instances_gen 8 \
    --Noise_Power 0.001 \
    --data 'cifar10' \
    --loss_m 'triplet' 
    --loss_confusion 'NPairLoss' \
    --log_dir 'Cifar10' \
    --epoch_gen 100 \
    --momentum 0.9 \
    --weight-decay 2e-4 \
    --momentum_0 0.9 \
    --weight-decay_0 5e-4 \
    --epochs_0 100 \
    --lr_0 0.001 \
    --BatchSize_0 256 \
    --task 5 \
    --base 2 \
    


Train for CIFAR-100 dataset:
```
python train.py \
    --lr 1e-6 \
    --lambda_task 0.2 \
    --lambda_scatter 0.8 \
    --lambda_mse 0.2 \
    --first_bn_mul 10.0 \
    --BatchSize 64 \
    --epochs 50 \
    --num_instances 16 \
    --batch_size_gen 16 \
    --num_instances_gen 8 \
    --Noise_Power 0.01 \
    --data 'cifar100' \
    --loss_m 'triplet' 
    --loss_confusion 'NPairLoss' \
    --log_dir 'Cifar100' \
    --epoch_gen 100 \
    --momentum 0.9 \
    --weight-decay 2e-4 \
    --momentum_0 0.9 \
    --weight-decay_0 5e-4 \
    --epochs_0 200 \
    --lr_0 0.001 \
    --task 10 \
    --base 10 \

Train for Mini-ImageNet dataset:
```
python train.py \
    --lr 1e-6 \
    --lambda_task 0.2 \
    --lambda_scatter 0.4 \
    --lambda_mse 0.2 \
    --first_bn_mul 15.0 \
    --BatchSize 64 \
    --epochs 50 \
    --num_instances 16 \
    --batch_size_gen 16 \
    --num_instances_gen 8 \
    --Noise_Power 0.01 \
    --data 'mini-imagenet-100' \
    --loss_m 'triplet' 
    --loss_confusion 'NPairLoss' \
    --log_dir ' Mini-imagenet-100' \
    --epoch_gen 100 \
    --momentum 0.9 \
    --weight-decay 2e-4 \
    --momentum_0 0.9 \
    --weight-decay_0 5e-4 \
    --epochs_0 200 \
    --lr_0 0.001 \
    --BatchSize_0 256 \
    --task 10 \
    --base 10 \

Train for tiny-imagenet-200 dataset:
```
python train.py \
    --lr 1e-6 \
    --lambda_task 0.2 \
    --lambda_scatter 0.4 \
    --lambda_mse 0.2 \
    --first_bn_mul 15.0 \
    --BatchSize 64 \
    --epochs 50 \
    --num_instances 16 \
    --batch_size_gen 16 \
    --num_instances_gen 4 \
    --Noise_Power 0.01 \
    --data 'tiny-imagenet-200' \
    --loss_m 'triplet' 
    --loss_confusion 'NPairLoss' \
    --log_dir 'Tiny-imagenet-200' \
    --epoch_gen 80 \
    --momentum 0.9 \
    --weight-decay 2e-4 \
    --momentum_0 0.9 \
    --weight-decay_0 5e-4 \
    --epochs_0 100 \
    --lr_0 0.001 \
    --BatchSize_0 256 \
    --task 20 \
    --base 100 \
    
----
For inference
```
python test.py 
---------

The directory tree structure for the Dataset folder should be like this (containing images):


├── cifar10
│   ├── train
│   └── test
├── cifar100
│   ├── train
│   └── test
├── mini-imagenet-100
│   ├── train
│   └── test
├── tiny-imagenet-200
    ├── train
    └── test

## Requirements
- python 3.9+
- torch 1.10.1+
- torchvision 0.11.2+
- scikit-learn 1.0.2
