# Code Overview
This directory contains scripts for evaluating and generating data for question decomposition, multi-hop QA, and reasoning tasks:

- `decompose_vllm.py`: Evaluates question decomposition performance using VLLM.

- `qa_vllm.py`: Evaluates question answering performance using VLLM.

- `rft_reason.py`: Generates reinforcement fine-tuning (RFT) data for reasoning tasks.

- `rft_mhqa.py`: Generates reinforcement fine-tuning (RFT) data for complex, multi-hop question answering.

We will release the full code upon the acceptance of the paper.

# Fine-tuning
We use the standard LLaMA-Factory codebase for both supervised fine-tuning (SFT) and reinforcement fine-tuning (RFT), without any modification. Therefore, the fine-tuning code is not included here.

Example datasets for SFT and RFT (with a small number of samples) are provided for reference.

