Graph Inference Representation: Learning Graph Positional Embeddings with Anchor Path Encoding

### About

Code for experiments in GIR (Graph Inference Representation: Learning Graph
Positional Embeddings with Anchor Path Encoding).

### Requirements

- Python 3.7
- dgl 0.6.1 (https://www.dgl.ai/pages/start.html)
- PyTorch 1.6.0 (https://pytorch.org/)
- Other packages listed in **requirements.txt**

### Shortcut Usage

We provide the **script.py** for quick experiment, the majority of subcommands are provided in a config file style, where includes the backbone of the subcommands, "{foo}" represents custom defined variable and "{{bar}}" represents special variable assigned by script.py.

See the help of **script.py**  for more details.

```
python script.py --help
```

#### Experiment Scripts

We provide experiment configs in the **experiments** folder, scripts for experiments are listed as follows.

Experiment results are backuped in **results/bak**.

##### Experiment 1:  synthetic datasets

```
python script.py -s experiments/dist/{method} --var experiments/dist/{vars/varsa/varsu/varsau} --experiment-set xxx --experiment {method} -r train --force --times 20 --data-versions 5 --cuda 0
```

##### Experiment 2: real-world datasets

```
python script.py -s experiments/pos/{task}/{method} --var experiments/pos/{task}/v_{data} --experiment-set xxx --experiment {method} -r "train" --force --times 20 --data-versions 5 --cuda 0
```



#### Metrics Report

```
python main.py script metrics-report --es {experiment_set}
```

Reports are saved in **results/report**