from graph_learning.config import Config, init_context_namespace, config_dispatch
from .transform import DataPipeline, DataTransform

@Config.register('data-setting', is_fold=True,
                 help='Build data processing pipeline.')
class DataSettingConfig(Config):
    def __init__(self, args, context):
        super().__init__(args, context)

    @property
    def builder(self):
        """ Datasetting class

        Returns
        -------
        type(DataTransform)
            Datasetting implement class.
        """
        raise NotImplementedError

    @classmethod
    def build(cls, args, context):
        """ General data-setting component's building process.

        Build DataPipeline for data transformation.
        """
        init_context_namespace(context, 'data')

        config = cls(args, context)
        transformer = config_dispatch(config.builder, config)

        if hasattr(context, 'tasker') and len(context.tasker) > 0:
            context.tasker.add_transformer(transformer)
        else:
            context.data = transformer.transform(context.data)
