from graph_learning.config import Config, init_context_namespace, config_dispatch

@Config.register('data', is_fold=True,
                 help='Datasets.')
class DatasetConfig(Config):
    def __init__(self, args, context):
        super().__init__(args, context)

    def build_dataset(self):
        raise NotImplementedError

    @classmethod
    def build(cls, args, context):
        init_context_namespace(context, 'data')
        config = cls(args, context)
        data = config.build_dataset()
        context.data = data
