from graph_learning.config import Config, parse_args

import os
import sys
import shutil

import torch

import numpy as np

from graph_learning.logger import CommonLogger#, PLLogger

def get_version(log_root):
    try:
        vs = [int(n[n.rindex('_')+1:])
              for n in os.listdir(log_root)]
        if len(vs) > 0:
            version = max(vs) + 1
    except FileNotFoundError:
        version = 0
    return version

@Config.register('global_',
                 help='Global settings.')
class GlobalConfig(Config):
    def __init__(self, args, context):
        super().__init__(args, context)
        self.device = 'cuda' if self.use_cuda else 'cpu'

        self.output_model_dir = os.path.join(self.output_dir, 'model')
        self.output_log_dir = os.path.join(self.output_dir, 'log')

        os.makedirs(self.output_dir, exist_ok=True)
        os.makedirs(self.output_model_dir, exist_ok=True)
        os.makedirs(self.output_log_dir, exist_ok=True)

        self.logger = CommonLogger(self.output_dir)
        self.logger.init()
        self.logger.log(self.script_save_name, self.script,
                        postfix=False, slient=True, append=False)

        self.logger = self.logger['log']

    @classmethod
    def define_parser(cls, parser):
        super().define_parser(parser)
        parser.add_argument('--use-cuda', action='store_true',
                            help='whether to use cuda, we only support single GPU setting now')

        parser.add_argument('--output-dir', required=True,
                            help='results output dir')

        parser.add_argument('--script',
                            help='subcommands running for the experiment')
        parser.add_argument('--script-save-name',
                            help='subcommands save name.')

    @staticmethod
    def build(args, context):
        config = GlobalConfig(args, context)
        context.global_.__dict__.update(config.__dict__)
        context._vars = {}

def main():
    parse_args()
