import torch
import torch.nn as nn

class Module(nn.Module):
    def __init__(self):
        super().__init__()

    def dynamic(self, name: str, module_class, device,
                *args, **kwargs):
        if not hasattr(self, name):
            module = module_class(*args, **kwargs).to(device)
            self.add_module(name, module)
        return getattr(self, name)
