from graph_learning.config import Config, config_dispatch, init_context_namespace
from .tasker import RootTasker, DataloaderTasker, TaskerChain, Tasker

@Config.register('tasker', is_fold=True,
                 help='Dataloaders, data interfaces and metrics.')
class TaskerConfig(Config):
    def __init__(self, args, context):
        super().__init__(args, context)
        self.logger = context.global_.logger

    @classmethod
    def define_parser(cls, parser):
        super().define_parser(parser)

    @property
    def builder(self):
        """ Tasker class

        Returns
        -------
        type(Tasker)
            Tasker implement class.
        """
        raise NotImplementedError

    @classmethod
    def build(cls, args, context):
        """ General tasker component's building process.
        Maintain TaskerChain object in context.tasker .
        """
        config = cls(args, context)

        is_init = init_context_namespace(context, 'tasker')
        if is_init:
            context.tasker = TaskerChain().apply(context.data)

        tasker = config_dispatch(config.builder, config)
        if isinstance(tasker, DataloaderTasker):
            context.tasker.new_roottasker()
        context.tasker.add_tasker(tasker)
