from typing import Callable
import inspect
from functools import partial

class TaskerData(object):
    """Auxiliary class that bind data and tasker together.
    """
    def __init__(self, tasker, data):
        self.tasker = tasker
        self.data = data

    def __getattr__(self, name):
        attr = getattr(self.tasker, name)
        if inspect.ismethod(attr):
            attr = partial(attr, self.data)
        return attr

def make_data(tasker, data):
    return TaskerData(tasker, data)

def cop_namespace(name):
    def decorate(func):
        def inner(*args, **kwargs):
            ret = func(*args, **kwargs)
            return {name: ret}
        return inner
    return decorate
