from graph_learning.config import Config, init_context_namespace, config_dispatch

@Config.register('trainer', is_fold=True,
                 help='Trainers.')
class TrainerConfig(Config):
    def __init__(self, args, context):
        super().__init__(args, context)

    @classmethod
    def define_parser(cls, parser):
        super().define_parser(parser)

    @property
    def builder(self):
        raise NotImplementedError

    @classmethod
    def build(cls, args, context):
        init_context_namespace(context, 'trainer')
        config = cls(args, context)
        trainer = config_dispatch(config.builder, config)
        context.trainer = trainer
