import inspect

class Trainer:
    def train(self):
        raise NotImplementedError

    def test(self):
        raise NotImplementedError

    def run(self, name, config):
        func = getattr(self, name)
        signature = inspect.signature(func)
        names = list(signature.parameters.keys())
        parameters = {name: getattr(config, name)
                      for name in names
                      if hasattr(config, name)}
        return func(**parameters)
