import argparse
import inspect
import collections
from collections import defaultdict, ChainMap
from functools import reduce

Namespace = argparse.Namespace

def dict_merge_rec(base_dct, merge_dct, add_keys=True):
    rtn_dct = base_dct.copy()
    if add_keys is False:
        merge_dct = {key: merge_dct[key] for key in set(rtn_dct).intersection(set(merge_dct))}

    rtn_dct.update({
        key: dict_merge_rec(rtn_dct[key], merge_dct[key], add_keys=add_keys)
        if isinstance(rtn_dct.get(key), dict) and isinstance(merge_dct[key], dict)
        else merge_dct[key]
        for key in merge_dct.keys()
    })
    return rtn_dct

def merge_dicts(dicts):
    return reduce(dict_merge_rec, dicts)

def merge_metrics(dicts, schema={}, namespace=None):
    if len(dicts) == 0:
        return {}
    if namespace is not None:
        dicts = [d[namespace] for d in dicts]
    metrics = defaultdict(list)
    mean = lambda l: float(sum(l) / len(l)) if len(l) > 0 else 0
    ret = {}
    for k, v in dicts[0].items():
        if isinstance(v, dict):
            subschema = schema[k] if k in schema else {}
            ret[k] = merge_metrics(
                [d[k] for d in dicts], subschema)
        else:
            subschema = schema[k] if k in schema else mean
            ret[k] = subschema([d[k] for d in dicts])
    return ret

def flatten_dict(d, parent_key='', sep='/'):
    items = []
    for k, v in d.items():
        new_key = parent_key + sep + k if parent_key else k
        if isinstance(v, collections.MutableMapping):
            items.extend(flatten_dict(v, new_key, sep=sep).items())
        else:
            items.append((new_key, v))
    return dict(items)

class HitCounter:
    count = 0

    @classmethod
    def hit(cls, max_time):
        cls.count += 1
        if cls.count > max_time:
            return True
        return False
