import pickle,os





def save_data(my_data_list, filename='modelnet_noisy_data.pkl'):
    """保存数据到文件"""
    # 获取目录路径
    filepath = os.path.dirname(filename)
    # 如果 filepath 不为空，则创建目录
    os.makedirs(filepath, exist_ok=True)
    # 保存数据到文件
    with open(filename, 'wb') as f:
        pickle.dump(my_data_list, f)
    print(f"数据已保存至 {filename}")





def load_data(filename='./modelnet_noisy_data.pkl'):
    """从文件加载数据"""
    with open(filename, 'rb') as f:
        my_data_list = pickle.load(f)
    print("数据已加载")
    return my_data_list







def select_elements_byIndexes(points_list,index_list):
    # print(len(list(points_list)))
    # print(index_list)
    res = [points_list[ind] for ind in index_list]
    return res




def dataset_name(filename):
    if "shift_mnist" in filename:
        name = "shift_mnist"
    elif "mnist" in filename:
        name = "mnist"
    else: 
        name = "my"
    return name


def sample_method(filename):
    if "/CS/" in filename:
        name = "CS"
    elif "/US/" in filename:
        name = "US"
    else:
        name = "Org"
    return name





