import os,sys,argparse,time
import numpy as np
parent_dir = os.path.abspath(os.path.join(os.getcwd(), "."))
sys.path.append(parent_dir)
print(parent_dir)
from __alg.CS_rwd import coreset
from __tool.tool import save_data, load_data


def main(args):
    # 解析输入参数
    noisy_dataset_file = args.noisy_dataset_file
    radius = args.radius
    k_ddim = args.k_ddim
    time0 = time.time()
    # 打印输入文件的绝对路径
    print("Input file absolute path:", os.path.abspath(noisy_dataset_file))
    points_list, weights_list, label_list, noisy_points_list, noisy_weights_list, noisy_label_list = load_data(noisy_dataset_file)
    _,_,_,cs_locs_list, cs_weis_list, cs_label_list = coreset(noisy_points_list, noisy_weights_list, noisy_label_list, radius, k_ddim)
    cs_file_name = os.path.join(noisy_dataset_file[:-4], f"CS/cs{radius}_{k_ddim}_{len(cs_locs_list)}.pkl")
    os.makedirs(os.path.dirname(cs_file_name), exist_ok=True)
    save_data((None,None,None,cs_locs_list, cs_weis_list, cs_label_list), cs_file_name)
    print(f"Core-set saved to: {os.path.abspath(cs_file_name)}")
    time1 = time.time()
    print("time0-time1 = ",time0-time1)

if __name__ == "__main__":
    # 设置命令行参数解析器
    parser = argparse.ArgumentParser(description="Process noisy MNIST data and compute core-set.")
    # parser.add_argument("--noisy_dataset_file", type=str, required=True, help="Path to the noisy MNIST .pkl file.")
    parser.add_argument("--noisy_dataset_file", type=str, default="my_dataset/ModelNet/my_ModelNet10/noisy_modelnet500_5_1_0.1_1234.pkl", help="Path to the noisy MNIST .pkl file.")
    parser.add_argument("--radius", type=float, default=10, help="Radius parameter for core-set computation.")
    parser.add_argument("--k_ddim", type=int, default=4, help="Dimensionality parameter for core-set computation.")
    parser.add_argument("--zeta_a", type=float, default=0.1, help="mass of outlier .")
    parser.add_argument("--zeta_b", type=float, default=0.1, help="mass of outlier")

    # 解析参数并调用主函数
    args = parser.parse_args()
    main(args)


