import os,sys,argparse,random
import numpy as np
parent_dir = os.path.abspath(os.path.join(os.getcwd(), "."))
sys.path.append(parent_dir)
print(parent_dir)
from __tool.tool import save_data, load_data,select_elements_byIndexes


def main(args):
    # 解析输入参数
    noisy_dataset_file = args.noisy_dataset_file
    sample_size = args.sample_size

    # 打印输入文件的绝对路径
    print("Input file absolute path:", os.path.abspath(noisy_dataset_file))
    points_list, weights_list, label_list, noisy_points_list, noisy_weights_list, noisy_label_list = load_data(noisy_dataset_file)
    dataset_size = len(list(noisy_label_list))
    sampled_indexes = random.sample(range(dataset_size), sample_size)
    us_locs_list, us_weis_list, us_label_list = select_elements_byIndexes(noisy_points_list,sampled_indexes),select_elements_byIndexes(noisy_weights_list,sampled_indexes),select_elements_byIndexes(noisy_label_list,sampled_indexes)
    us_file_name = os.path.join(noisy_dataset_file[:-4], f"US/us{len(us_locs_list)}.pkl")
    os.makedirs(os.path.dirname(us_file_name), exist_ok=True)
    save_data((None,None,None,us_locs_list, us_weis_list, us_label_list), us_file_name)
    print(f"Core-set saved to: {os.path.abspath(us_file_name)}")

if __name__ == "__main__":
    # 设置命令行参数解析器
    parser = argparse.ArgumentParser(description="Process noisy MNIST data and compute core-set.")
    parser.add_argument("--noisy_dataset_file", type=str, required=True, help="Path to the noisy MNIST .pkl file.")
    parser.add_argument("--sample_size", type=int, default="100")

    # 解析参数并调用主函数
    args = parser.parse_args()
    main(args)


