#!/bin/bash
# shellcheck disable=SC2120
function run_proxylessnas() {
  model=$1
  lossType=$2
  wid=$3
  count=$5
  batch=$6
  echo start "${model}" "${lossType}" "$wid" "${count}"
  dir=./checkpoints/oneshot/"${model}"/"${count}"/"${lossType}"
  #  search
  mkdir -p "${dir}"
  python main.py  \
  --net "${model}" \
  --dataset imagenet \
  --data_path ~/data/ \
  --grad_reg_loss_type "${lossType}" \
  --worker_id "$wid" \
  --epochs 120 \
  --train_batch_size "${batch}" \
  --ref_latency "${count}" \
  --checkpoint_path "${dir}"/arch_path.pt \
  --exported_arch_path "${dir}"/checkpoint.json \
  --train_mode "$4" \
  --kd_teacher_path ./checkpoints/teacher/d2_224_85.2.pth.tar
}

run_proxylessnas "$1" add#linear 0 "$2" "$3" "$4"
