# SPDX-FileCopyrightText: Copyright (c) 2025, NVIDIA CORPORATION & AFFILIATES.
# All rights reserved.
# SPDX-License-Identifier: Apache-2.0

from src.settings import API, DATASET_PAPER_LINK, PRETTY_NAME_TO_PAPER_LINK, REPO_ID


def restart_space():
    API.restart_space(repo_id=REPO_ID)


def make_dataset_clickable(dataset_name):
    if dataset_name in DATASET_PAPER_LINK:
        link = DATASET_PAPER_LINK[dataset_name]
    else:
        link = f"https://huggingface.co/datasets/{dataset_name}"
    return link


def make_model_clickable(model_name):
    link = f"https://huggingface.co/{model_name}"
    return f'<a target="_blank" href="{link}" style="color: var(--link-text-color); text-decoration: underline;text-decoration-style: dotted;">{model_name}</a>'


def make_method_clickable(method_name, press_init_command=None):
    """
    Make method name clickable with optional tooltip showing press_init_command.

    Parameters
    ----------
    method_name : str
        The method name to make clickable
    press_init_command : str, optional
        The press initialization command to show as tooltip
    """

    if method_name in PRETTY_NAME_TO_PAPER_LINK:
        base_link = PRETTY_NAME_TO_PAPER_LINK[method_name]
        # If we have a press_init_command, add it as a tooltip
        if press_init_command:
            # Create a tooltip using HTML title attribute
            tooltip_html = f'<span style="cursor: help;" title="{press_init_command}">{base_link}</span>'
            return tooltip_html
        else:
            return base_link
    else:
        print(f"Method {method_name} not found in METHOD_PAPER_LINK")
        return method_name
