# LLMs-Exploration
## Overview

Large Language Models (LLMs) have demonstrated remarkable intellectual capacities, but their ability to explore remains underexplored. Exploration is crucial for discovering new information and adapting to novel environments in both natural and artificial systems. This study investigates whether LLMs can surpass humans in exploration during an open-ended task, using *Little Alchemy 2* as a paradigm, where agents combine elements to discover new ones. 

## Repository Structure

This repository includes implementations for running open-ended exploration experiments with various LLMs (GPT, LLaMA3.1-8B, LLaMA3.1-70B, and DeepSeek), as well as methods for analyzing their performance using representational and cognitive modeling.

- **`experiment/`** – Scripts to run *Little Alchemy 2* experiments with different LLMs.
- **`dataset/`** – The dataset of *Little Alchemy 2* and human data.
- **`data_analysis/`** – Data processing, LLM performance evaluation, and behavior analysis.
- **`SAE/`** – Training Sparse Autoencoders (SAE) and performing cognitive analysis.
- **`regression/`** – Regression models for understanding the role of uncertainty and empowerment in exploration.

---

## Data
You can get the LLMs data from this link [https://osf.io/9swmp/files/osfstorage#
](https://osf.io/9swmp/files/osfstorage?view_only=f5704a73939a463bb899fe17c9e3d858)
