# Efficient Winning Tickets Drawing over Fine-Grained Structured Sparsity

This repository is the official implementation of "Efficient Winning Tickets Drawing over Fine-Grained Structured Sparsity" submitted to ICLR 2022. 

> 📋 This implmentation is developed based on the source code of OpenLTH, which is available at: https://github.com/facebookresearch/open_lth

## Requirements
> 📋 To run the code, you need to install Python>=3.7, PyTorch>=1.4, TorchVision>=0.5.0

## CIFAR Training

To train the model(s) for CIFAR-10, run this command:

```train
python open_lth.py lottery --default_hparams xxx --levels=10 --training_steps xxx --milestone_steps xxx --rewinding_steps=xxx --replicate 1
```
> 📋--default_hparams can be one of the following three options: cifar_resnet_20, cifar_resnet_50, cifar_vgg_16. For example 'cifar_resnet_20' means loading the default hyperparameters for ResNet-20.

> 📋--levels is the maximum possible number of pruning rounds for iterative pruning, it is set to 10 by default, but the iterative pruning will stop much earlier.

> 📋--training_steps is the number of total iterations per pruning round, it is set to '30000it' for ResNet-20 and ResNet-50, and '63000it' for VGG-16.

> 📋--milestone_steps is the steps for the learning rate decay, it is set to '20000it,25000it' for ResNet-20 and ResNet-50 and '32000it,48000it' for VGG-16.

> 📋--rewinding_steps is the steps for weight rewinding, it is set to '500it' for ResNet-20 and ResNet-50 and '1000it' for VGG-16.

> 📋--replicate is the index for the current run of experiments.


## ImageNet Training

To train the model(s) for ImageNet, run this command:

```train
python open_lth.py lottery --default_hparams xxx --levels=10 --training_steps 90ep --milestone_steps 30ep,60ep,80ep --rewinding_steps=4ep --replicate 1
```

> 📋--default_hparams can be one of the following three options: imagenet_resnet_18, imagenet_resnet_50, imagenet_vgg_16.

> 📋--levels is the maximum possible number of pruning rounds for iterative pruning, it is set to 10 by default, but the iterative pruning will stop much earlier.

> 📋--training_steps is the number of total iterations per pruning round, it is set to '90ep' for all the DNNs.

> 📋--milestone_steps is the steps for the learning rate decay, it is set to '30ep,60ep,80ep' for all the DNNs.

> 📋--rewinding_steps is the steps for weight rewinding, it is set to '4ep' for all DNNs.

> 📋--replicate is the index for the current run of experiments.



