## To Simulate Neural Organoid: A Framework and A Benchmark based on AI

#### Requirments
* python 3.10
* Please run the following command to get the project dependencies
```
    pip install -r requirements.txt
```

#### run 
Run `python main.py` to get the results.
To run different experiments, adjust the `Experiment_id` in `args.json`:
    * 0 : Simulation similarity evaluation
    * 1 : Simulation intelligent evaluation (2D model)
    * 2 : Simulation intelligent evaluation (3D model)

Critical hyperparameters in `args.json` are explained below:
* `Experiment_0`:
    * `group`: 0/1/2 represent three groups of real-world experiment organoid data.
    * `visualization`: 
        * 0 : No visualization
        * 1 : If visualization is required, please ensure that your system can use matplotlib normally (QT can be used normally)
* `Experiment_1`:
    * `use_weight`: Whether to use the weight of the baseline model
    * `I_max`: Intensity Encoding

#### Important statements 
* Due to defects in loding and saving weights in the `brainpy` model (missing key values due to relative path retrieval), for simulation intelligent evaluation, the accuracy of each running will produce varying degrees of change (Not more than 2%), compared with the baseline we give in the paper.

#### Expansion evalution dataset gereration
* If you test the expansion evalution for the first time, use `python expansion_evaluation.py` to get the dateset(`intelligence_expansion/dataset`) and weights files(`class_10.bp` and `class_10.npy`).
* If having the weights files already (have run the the code before), uncomment lines 101-105 and comment lines 85-98 in `expansion_evaluation.py` to make it run faster.