
import pennylane as qml
from pennylane.ops import CNOT, RX, RY, RZ, CZ
from pennylane import numpy as np
import random
import numpy.linalg as la
import math
from math import pi
from datetime import datetime
import os
import optimizer

# Parameters
n_qubits = 15
n_layer = 10
n_time = 5
n_check = 20
iteration = 100



dev = qml.device("default.qubit", wires=n_qubits)
@qml.qnode(dev, interface="autograd", diff_method="backprop")

def cl_circuit(params):
    k = 0
    for i in range(n_layer):
        for j in range(n_qubits):
            qml.CZ(wires=[j,(j+1)%n_qubits])
        for j in range(n_qubits):
            qml.RX(2*params[k], wires=j)
            k = k + 1
        for j in range(n_qubits):
            qml.RY(2*params[k], wires=j)
            k = k + 1

    return [qml.expval(qml.PauliX(n) @ qml.PauliX((n+1)%n_qubits) + qml.PauliY(n) @ qml.PauliY((n+1)%n_qubits) + qml.PauliZ(n) @ qml.PauliZ((n+1)%n_qubits)) for n in range(n_qubits-1)]




t1 = datetime.now()
circuit_name = "xxx"
gamma = 1/(8*n_layer)**0.5
n_params = 2*n_layer*n_qubits

#noiseless
optimizer.gd_gaussian(cl_circuit, circuit_name, n_qubits, n_params, gamma, 0.01, 0, 0, 0.01, iteration, n_time, n_check)
optimizer.gd_gaussian(cl_circuit, circuit_name, n_qubits, n_params, gamma, 0.1, 0, 0, 0.01, iteration, n_time, n_check)
optimizer.gd_gaussian(cl_circuit, circuit_name, n_qubits, n_params, gamma, 1, 0, 0, 0.01, iteration, n_time, n_check)
optimizer.gd_gaussian(cl_circuit, circuit_name, n_qubits, n_params, gamma, 10, 0, 0, 0.01, iteration, n_time, n_check)
optimizer.gd_gaussian(cl_circuit, circuit_name, n_qubits, n_params, gamma, 100, 0, 0, 0.01, iteration, n_time, n_check)
optimizer.gd_zero(cl_circuit, circuit_name, n_qubits, n_params, gamma, 1, 0, 0, 0.01, iteration, n_time, n_check)
optimizer.gd_uniform(cl_circuit, circuit_name, n_qubits, n_params, gamma, 1, 0, 0, 0.01, iteration, n_time, n_check)

#noisy
optimizer.gd_gaussian(cl_circuit, circuit_name, n_qubits, n_params, gamma, 0.01, 1/(100)**0.5, 1, 0.01, iteration, n_time, n_check)
optimizer.gd_gaussian(cl_circuit, circuit_name, n_qubits, n_params, gamma, 0.1, 1/(100)**0.5, 1, 0.01, iteration, n_time, n_check)
optimizer.gd_gaussian(cl_circuit, circuit_name, n_qubits, n_params, gamma, 1, 1/(100)**0.5, 1, 0.01, iteration, n_time, n_check)
optimizer.gd_gaussian(cl_circuit, circuit_name, n_qubits, n_params, gamma, 10, 1/(100)**0.5, 1, 0.01, iteration, n_time, n_check)
optimizer.gd_gaussian(cl_circuit, circuit_name, n_qubits, n_params, gamma, 100, 1/(100)**0.5, 1, 0.01, iteration, n_time, n_check)
optimizer.gd_zero(cl_circuit, circuit_name, n_qubits, n_params, gamma, 1, 1/(100)**0.5, 1, 0.01, iteration, n_time, n_check)
optimizer.gd_uniform(cl_circuit, circuit_name, n_qubits, n_params, gamma, 1, 1/(100)**0.5, 1, 0.01, iteration, n_time, n_check)

#noiseless
optimizer.adam_gaussian(cl_circuit, circuit_name, n_qubits, n_params, gamma, 0.01, 0, 0, 0.01, iteration, n_time, n_check)
optimizer.adam_gaussian(cl_circuit, circuit_name, n_qubits, n_params, gamma, 0.1, 0, 0, 0.01, iteration, n_time, n_check)
optimizer.adam_gaussian(cl_circuit, circuit_name, n_qubits, n_params, gamma, 1, 0, 0, 0.01, iteration, n_time, n_check)
optimizer.adam_gaussian(cl_circuit, circuit_name, n_qubits, n_params, gamma, 10, 0, 0, 0.01, iteration, n_time, n_check)
optimizer.adam_gaussian(cl_circuit, circuit_name, n_qubits, n_params, gamma, 100, 0, 0, 0.01, iteration, n_time, n_check)
optimizer.adam_zero(cl_circuit, circuit_name, n_qubits, n_params, gamma, 1, 0, 0, 0.01, iteration, n_time, n_check)
optimizer.adam_uniform(cl_circuit, circuit_name, n_qubits, n_params, gamma, 1, 0, 0, 0.01, iteration, n_time, n_check)

#noisy
optimizer.adam_gaussian(cl_circuit, circuit_name, n_qubits, n_params, gamma, 0.01, 1/(100)**0.5, 1, 0.01, iteration, n_time, n_check)
optimizer.adam_gaussian(cl_circuit, circuit_name, n_qubits, n_params, gamma, 0.1, 1/(100)**0.5, 1, 0.01, iteration, n_time, n_check)
optimizer.adam_gaussian(cl_circuit, circuit_name, n_qubits, n_params, gamma, 1, 1/(100)**0.5, 1, 0.01, iteration, n_time, n_check)
optimizer.adam_gaussian(cl_circuit, circuit_name, n_qubits, n_params, gamma, 10, 1/(100)**0.5, 1, 0.01, iteration, n_time, n_check)
optimizer.adam_gaussian(cl_circuit, circuit_name, n_qubits, n_params, gamma, 100, 1/(100)**0.5, 1, 0.01, iteration, n_time, n_check)
optimizer.adam_zero(cl_circuit, circuit_name, n_qubits, n_params, gamma, 1, 1/(100)**0.5, 1, 0.01, iteration, n_time, n_check)
optimizer.adam_uniform(cl_circuit, circuit_name, n_qubits, n_params, gamma, 1, 1/(100)**0.5, 1, 0.01, iteration, n_time, n_check)

t2 = datetime.now()
print("qubits: ", n_qubits, "layers: ", n_layer, 'seconds for ', circuit_name,  (t2-t1).seconds)

