# zero-shot intent classification

## Basic Setup
```
mkdir data
cd data
wget http://nlp.stanford.edu/data/glove.840B.300d.zip
unzip glove.840B.300d.zip
```
Download the data and graph from the [google drive](https://drive.google.com/drive/folders/1CpuSge0K339bWZZbU8ODsDpagqYJn44-?usp=sharing)
and extract in `data`.

## ZSL-KG
These are instructions to run the ZSL-KG framework with different graph aggregators.

```
python train.py --label_encoder_type transformer --seed 0 --weight-decay 0.00001 --joint-dim 16
```

options for `--label_encoder_type`:
1. transformer (ZSL-KG)
2. lstm (LSTM)
3. gat (GAT)
4. gcn (GCN)
5. rgcn (RGCN)

## Other graph baselines
Running graph neural networks with Imagenet graph:

```
python train_graph_baseline.py --label_encoder_type gcnz --seed 0 --weight-decay 0.00001 --joint-dim 16
```

options for `--label_encoder_type`:
1. gcnz
2. sgcn
3. dgp