"""The file contains utilities for several functions
"""
import io
import torch
import numpy as np
import scipy.sparse as sp

def file_tokens_to_idx(file_path):
    """The function is used to load the tokens from the file
    and return and dictionary with token to idx mapping.    
    
    Arguments:
        file_path {str} -- the file path
    
    Returns:
        dict -- the mapping of token to idx
    """
    tokens_to_idx = {}
    with io.open(file_path) as fp:
        for idx, line in enumerate(fp.readlines()):
            tokens_to_idx[line.strip()] = idx

    return tokens_to_idx


def normt_spm(mx, method='in'):
    if method == 'in':
        mx = mx.transpose()
        rowsum = np.array(mx.sum(1))
        r_inv = np.power(rowsum, -1).flatten()
        r_inv[np.isinf(r_inv)] = 0.
        r_mat_inv = sp.diags(r_inv)
        mx = r_mat_inv.dot(mx)
        return mx

    if method == 'sym':
        rowsum = np.array(mx.sum(1))
        r_inv = np.power(rowsum, -0.5).flatten()
        r_inv[np.isinf(r_inv)] = 0.
        r_mat_inv = sp.diags(r_inv)
        mx = mx.dot(r_mat_inv).transpose().dot(r_mat_inv)
        return mx


def spm_to_tensor(sparse_mx):
    sparse_mx = sparse_mx.tocoo().astype(np.float32)
    indices = torch.from_numpy(np.vstack(
            (sparse_mx.row, sparse_mx.col))).long()
    values = torch.from_numpy(sparse_mx.data)
    shape = torch.Size(sparse_mx.shape)
    return torch.sparse.FloatTensor(indices, values, shape)