# Zero-shot object classification
The code was adapted from `https://github.com/cyvius96/DGP`.

## Setup
```
mkdir data
mkdir save
mkdir apy_save
mkdir awa_save
```
all the `.pred` files will be saved in the `save` directory.

Download the data from [google drive](https://drive.google.com/drive/folders/1CpuSge0K339bWZZbU8ODsDpagqYJn44-?usp=sharing) and extract the zip in `data`.

## Download dataset
You can download the AWA2 dataset from [https://cvml.ist.ac.at/AwA2/AwA2-data.zip](https://cvml.ist.ac.at/AwA2/AwA2-data.zip). This dataset
is 13GB.
aPY dataset is a combination of two datasets - Attribute Pascal and Attribute Yahoo datasets.

Download a-yahoo dataset from [http://vision.cs.uiuc.edu/attributes/ayahoo_test_images.tar.gz](http://vision.cs.uiuc.edu/attributes/ayahoo_test_images.tar.gz) and place them in `materials/datasets/awa2`

Download a-pascal dataset from [http://host.robots.ox.ac.uk/pascal/VOC/voc2008/VOCtrainval_14-Jul-2008.tar](http://host.robots.ox.ac.uk/pascal/VOC/voc2008/VOCtrainval_14-Jul-2008.tar)

Extract the dataset from both the dataset and place them in `materials/datasets/aPY/raw`.

We need to make use of the bbox information to crop the images and place them in their respective directories.
To preprocess the dataset, execute the following:
```
cd materials
python apy_dataset.py
```

## Train ZSL-KG models
```
python resnet_experiments.py --label_encoder transformer --max-epoch 1000
```

You can replace `--label_encoder` with `gcn`, `gat`, `rgcn`, `lstm` for ZSL-KG ablations.
For the baseline you can replace `--label_encoder` with `gcnz`, `sgcn`, and `dgp`.

### Testing ZSL-KG on AWA2
```
python evaluate_awa2.py --pred <path to .pred>
```

### Testing ZSL-KG on APY
```
python evaluate_apy.py --pred <path to .pred>
```
