%% This uses Chebfun package. To download, see https://github.com/chebfun/chebfun for details
%% Decay figure of singular values: 
% Figure 1 (left) 

f = chebfun2(@(x,y) max(0, 1 - abs(x) - abs(y)), [3000,3000]);
s = svd(f); 

%%
r = 0; V = 1; 
k = (r+1):2000; 
bound = (sqrt(2) * V) ./ ((sqrt(pi * (r + 1/2)) .* sqrt((k - r - 1).^(r + 1/2))));

legcfs = legcoeffs(f(:,0));  %max over y happens at y=0
legcfs = legcfs.*sqrt(2./(2*(0:numel(legcfs)-1)'+1));
for j = 1:2000
    leg(j) = norm(legcfs(j:end));
    exact(j) = norm(s(j:end));
    %bd(j) = norm(bound(j:end)); 
end
loglog(1:numel(exact), exact, '.', 'markersize',20), hold on, 
loglog(1:numel(leg), leg, 'k--', 'linewidth', 2)
%loglog(1:numel(bound), bound,'linewidth',2)
set(gca,'fontsize',16), ylim([9e-6,1])


%% 
% Figure 1 (right)

% Define the smooth square cone kernel
R = 1; sigma = 100; 
K = exp(-(x.^2 + y.^2) / (2*sigma^2)) .* max(0, (1 - (abs(x) + abs(y)) / R));

%K = (x.^2 + y.^2 <= R^2) .* exp(-1 ./ (1 - (x.^2 + y.^2) / R^2));
f = chebfun2(K);
s = svd(f);

%%
r = 0; V = 1; 
k = (r+1):2000; 
bound = (sqrt(2) * V) ./ ((sqrt(pi * (r + 1/2)) .* sqrt((k - r - 1).^(r + 1/2))));

legcfs = legcoeffs(f(:,0));  %max over y happens at y=0
legcfs = legcfs.*sqrt(2./(2*(0:numel(legcfs)-1)'+1));
for j = 1:2000
    leg(j) = norm(legcfs(j:end));
    exact(j) = norm(s(j:end));
    %bd(j) = norm(bound(j:end)); 
end
semilogy(1:numel(exact), exact, '.', 'markersize',20), hold on, 
semilogy(1:numel(leg), leg, 'k--', 'linewidth', 2)
%loglog(1:numel(bound), bound,'linewidth',2)
set(gca,'fontsize',16), xlim([1,50]), ylim([9e-6,1])


%% Figure 2, pivoting figure 
% Figure 2 (left) 

c = 100; d = 1; 
f = chebfun2(@(x,y) tanh(c*x.*y+d));
plot(f,'-b','markersize',1,'linewidth',2), axis off, hold on, 
plot(f,'.r','markersize',30)

%%
% Figure 2 (right) 
s = svd(f); 
[C,D,R] = cdr(f); 
for j = 1:numel(s)
    ge(j) = norm( f - C(:,1:j)*D(1:j,1:j)*R(:,1:j)' );
    best(j) = norm(s(j+1:end)); 
end
%%
semilogy(1:numel(s),ge,'.','markersize',20), hold on
semilogy(1:numel(s),best,'.','markersize',20), hold on
set(gca,'fontsize',16), shg


