import math

import torch


def log(x: torch.Tensor):
    if isinstance(x, (float, int)):
        return math.log(float(x))
    return torch.log(x + torch.finfo(torch.float32).eps)
