import argparse
import warnings

warnings.simplefilter('ignore')
parser = argparse.ArgumentParser(add_help = False)

# data-related parameters
parser.add_argument('--seed', type = int, default = 0)
parser.add_argument('--device', type = str, default = 'cuda:0')
parser.add_argument('--data_path', type = str, default = '../dataset')
parser.add_argument('--data_name', type = str, default = 'assist2009')
parser.add_argument('--seq_len', type = int, default = 100)
parser.add_argument('--fold', type = int, default = 5)
# model-related parameters
parser.add_argument('--iter_count', type = int, default = 30)
parser.add_argument('--clr_num', type = int, default = 16)
parser.add_argument('--hidden_dim', type = int, default = 128)
parser.add_argument('--batch_size', type = int, default = 40)
parser.add_argument('--ce_batch_size', type = int, default = 400)
parser.add_argument('--dropout', type = float, default = 0.00)
parser.add_argument('--lr', type = float, default = 0.001)
parser.add_argument('--wd', type = float, default = 0.00)
parser.add_argument('--lamb', type = float, default = 4.0)
parser.add_argument('--itr_num', type = int, default = 30)
# result-related parameters
parser.add_argument('--summary', action = 'store_true')
parser.add_argument('--detail', action = 'store_true')
parser.add_argument('--result', action = 'store_true')
parser.add_argument('--save_sum', type = str, default = None)
parser.add_argument('--save_clr', type = str, default = None)
parser.add_argument('--save_each_clr', type = str, default = None)
parser.add_argument('--save_model', type = str, default = None)
parser.add_argument('--quit_epoch', type = int, default = 10)

args, _ = parser.parse_known_args()
