############################# Loading libraries #############################
library(caret)
tryNA <- function(expr) tryCatch(expr, error = function(e) NA)
############################# Data loader #################################
data_reader <- function(
    name = c("airfoil", "concrete", "diabetes", "energy",
             "fish", "forest_fire", "ltfsid", 
             "naval_compressor", "naval_turbine", 
             "real", "wine", "yacht") 
){
  
  name <- match.arg(name)
  data <- read.table(paste0("benchmark_data/", name, ".data"))
  return(data)
  
}
########################### Benchmark function #############################

data <- data_reader("airfoil")

X <- data[,1:(ncol(data)-1)]
# exclude columns with not enough unique values
X <- X[,which(apply(X, 2, function(x) length(unique(x)))>10)]
X <- as.data.frame(scale(X))
y <- data[,ncol(data)]

set.seed(1)
folds <- createFolds(y, k = 10)
testind = folds[[1]]

# source models within apply to allow for parallelization
source("../common/models.R")

# data
trainind <- setdiff(1:nrow(X), testind)
trainX <- X[trainind,]
trainY <- as.numeric(y[trainind])
testX <- X[testind,]
testY <- as.numeric(y[testind])

fun_w_ar <- function(fun, ar=NULL)
{
  
  args <- list(trainX = trainX,
               trainY = trainY,
               testX = testX,
               testY = testY,
               # maxEpochs = 1L,
               architecture = NULL
  )
  if(!is.null(ar)){
    args$architecture <- ar
  }
  
  tryNA(do.call(fun, args))
}

deepneatls_a = fun_w_ar(deepneatls, "a")
deepneatls_b = fun_w_ar(deepneatinter, "a")
