import bpy
import json, os, glob





def clear_world():
    print("Running clear_world")
    # Delete all objects and meshes
    for obj in bpy.data.objects:
        bpy.data.objects.remove(obj, do_unlink=True)
    for mes in bpy.data.meshes:
        bpy.data.meshes.remove(mes, do_unlink=True)


def export_obj(name, save_path):
    bpy.ops.object.select_all(action='DESELECT')
    if name in bpy.context.scene.objects.keys():
        obj = bpy.data.objects[name]
        obj.select_set(True)
        export_path = f'{save_path}/{name}.obj'
        bpy.ops.export_scene.obj(filepath=export_path, use_selection=True)

def seperate_parts():
    bpy.ops.object.mode_set(mode='OBJECT')
    bpy.ops.object.select_all(action='SELECT')
    ori_obj_list = [obj.name for obj in bpy.context.selected_objects]
    exist_part_list = []
    for obj in bpy.context.selected_objects:
        if obj.type == 'MESH' and len(obj.vertex_groups) != 0:
            bpy.context.view_layer.objects.active = obj
            bpy.ops.object.mode_set(mode='EDIT')
            bpy.ops.mesh.select_mode(type='VERT')
            for vgroup in obj.vertex_groups:
                empty = not any(vgroup.index in [g.group for g in v.groups] for v in obj.data.vertices)
                if not empty:
                    exist_part_list.append(vgroup.name)
                    bpy.ops.mesh.select_all(action='DESELECT')
                    bpy.ops.object.vertex_group_set_active(group=vgroup.name)
                    bpy.ops.object.vertex_group_select()
                    bpy.ops.mesh.separate(type='SELECTED')
                # else:
                #     part_list.remove(vgroup.name)
            bpy.ops.object.mode_set(mode='OBJECT')
    bpy.ops.object.select_all(action='SELECT')
    count = 0
    for obj in bpy.context.selected_objects:
        if obj.name in ori_obj_list:
            obj.select_set(False)
        else:
            obj.name = exist_part_list[count]
            count = count+1


    
    

def merge_parts(part_list, save_path, model_uid, json_path):
    clear_world()
    exist_part_list = []
    for part in part_list:
        part_path = f'{save_path}/{part}.obj'
        if os.path.exists(part_path):
            bpy.ops.import_scene.obj(filepath=part_path)
            obj = bpy.context.selected_objects[0]
            obj.name = part
            exist_part_list.append(part)
    for part in exist_part_list:
        ob = bpy.data.objects[part]
        group = ob.vertex_groups.new(name=part)
        for v in ob.data.vertices:
            group.add([v.index], 1.0, 'REPLACE')
    bpy.context.view_layer.objects.active = bpy.data.objects[exist_part_list[0]]
    bpy.ops.object.select_all(action='SELECT')
    bpy.ops.object.join()
    new_obj = bpy.context.selected_objects[0]
    new_obj.name = model_uid
#    export_path = f'{save_path}/{model_uid}.obj'
#    bpy.ops.export_scene.obj(filepath=save_path, use_selection=True)
    part_idx = {partName: [] for partName in part_list}
    for v in new_obj.data.vertices:
        for g in v.groups:
            for partName in exist_part_list:
                if g.group == new_obj.vertex_groups[partName].index:
                    part_idx[partName].append(v.index)
    with open(json_path, "w") as f:
        json.dump(part_idx, f)



if __name__ == "__main__":
    part_file_path = "./n03769881/part_list.txt"
    
    with open(part_file_path, 'r') as file:
        partList = []
        for line in file:
            partList.append(line.strip())
    
    model_uid = '3264ec81f296486d9c9d195e6b122441'
    save_path = f'./n03769881/models/{model_uid}'
    if not os.path.exists(save_path):
        os.makedirs(save_path)
        
    json_path = f'./n03769881/{model_uid}.json'
    
    seperate_parts()
    
    for part in partList:
        export_obj(part, save_path)
    merge_parts(partList, save_path, model_uid, json_path)
    export_obj(model_uid, save_path)

    

