# [Part321]: Recognizing 3D Object Parts from a 2D Image Using 1-Shot Annotation

## Installation
The code is tested with python 3.7, PyTorch 1.5 and PyTorch3D 0.2.0.

## Running Part321
We provide the scripts to train Correspondence and inference on VehiclePart3D, ImagenetPart and UDAPart datasets.

**Step 1: Prepare Datasets**  
Put the data to the main folder (Part321).

The categories of each dataset are listed below as tables:
- VehiclePart3D: "minibus", "airliner", "police", "jeep", "bicycle"
- ImagenetPart: "car", "aeroplane", "bicycle", "boat"
- UDAPart: "car", "aeroplane", "bicycle", "boat"

**Step 2: Training Correspondence**

To train the model on **VehiclePart3D**, run the following command:
```
python3 scripts/train.py \
    --cate {CATEGORY} \
    --config config/part_correspondence_vehicle.yaml \
    --save_dir exp/corr_vehicle_{CATEGORY}

```

To train the model on **UDAPart**, run the following command:
```
python3 scripts/train.py \
    --cate {CATEGORY} \
    --config config/part_correspondence_uda.yaml \
    --save_dir exp/corr_uda_{CATEGORY}

```

To train the model on **ImagenetPart**, run the following command:
```
python3 scripts/train.py \
    --cate {CATEGORY} \
    --config config/part_correspondence_imagenet.yaml \
    --save_dir exp/corr_imagenet_{CATEGORY}

```
**Note**: Replace {CATEGORY} with the category you want. The categories are listed previously. The trained model will be saved in "exp/corr_vehicle_{CATEGORY}".

**Step 3: Inference with Correspondence**  

Run this command to conduct inference on **VehiclePart3D**:
```
python3 scripts/inference.py \                                                                       
    --cate {CATEGORY} \
    --config config/part_correspondence_vehicle.yaml \
    --save_dir exp/vehicle_{CATEGORY}_result \
    --checkpoint exp/corr_vehicle_{CATEGORY}/ckpts/model_600.pth
```

Run this command to conduct inference on **UDAPart**:
```
python3 scripts/inference.py \                                                                       
    --cate {CATEGORY} \
    --config config/part_correspondence_uda.yaml \
    --save_dir exp/uda_{CATEGORY}_result \
    --checkpoint exp/corr_uda_{CATEGORY}/ckpts/model_600.pth
```

Run this command to conduct inference on **ImagenetPart**:
```
python3 scripts/inference.py \                                                                       
    --cate {CATEGORY} \
    --config config/part_correspondence_imagenet.yaml \
    --save_dir exp/imagenet_{CATEGORY}_result \
    --checkpoint exp/corr_imagenet_{CATEGORY}/ckpts/model_600.pth
```

**Note**: It will load the model in "exp/corr_imagenet_{CATEGORY}". Replace {CATEGORY} with the category you want. The categories are listed previously. 
The visualization will be saved in "exp/vehicle_{CATEGORY}_result".