import torch
import numpy as np

config = {
    'save_dir': None,
    'scene_encoder_path': 'PATH/TO/scene_encoder.pt',
    'save_every': 100000,
    'compile_models': True,
    # Model config
    'local_num_freq': 10,
    'local_nn_dim': 512,
    'hidden_dim': 1024,
    'num_demos': 2,
    'num_demos_test': 2,
    'traj_horizon': 10,
    'device': 'cuda',
    'batch_size': 16,
    'batch_size_val': 1,
    'num_scenes_nodes': 16,
    'pre_horizon': 8,
    'h_horizon': 0, # legacy.
    'num_gripper_nodes': 6,  # 6 or 10
    'pos_in_nodes': True,

    'num_layers': 2,
    # Diffusion config
    'lr': 1e-5,
    'weight_decay': 1e-2,
    'num_diffusion_iters_train': 100,
    'num_diffusion_iters_test': 4,
    'num_warmup_steps': 1000,
    'num_iters': 2500000,

    'test_every': 50000,
    'randomize_g_prob': 0.1,

    'min_actions': torch.tensor([-0.01] * 3 + [-np.deg2rad(3), -np.deg2rad(3), -np.deg2rad(3)], dtype=torch.float32),
    'max_actions': torch.tensor([0.01] * 3 + [np.deg2rad(3), np.deg2rad(3), np.deg2rad(3)], dtype=torch.float32),
}
