# Reinforcement Learning Policy as Macro Regulator Rather than Macro Placer

This repository contains implementation for Reinforcement Learning Policy as Macro Regulator Rather than Macro Placer.

# Benchmark Installation
Download the ICCAD2015 benchmark and move it to `benchmark/` folder. 

## Environment Installation
Use the Docker container to run our code.

1. Install Docker on [Linux](<https://docs.docker.com/get-docker/>).
2. Install [NVIDIA-docker](<https://docs.nvidia.com/datacenter/cloud-native/container-toolkit/latest/install-guide.html>) according to the install guide.
3. Build the docker container with the docker file.
```
docker build . --file Dockerfile.txt --tag your_name/maskregulate:cuda
```

Run with GPU on Linux.
```
docker run --gpus all -it -v $(pwd):/workspace your_name/maskregulate:cuda bash
```
Install Python dependencies.
```
pip install -r requirement.txt
```
Navigate to the `src` directory
```
cd src
```

## Run an experiment
```
python main.py --benchmark_train=[Benchmark1,Benchmark2] --benchmark_eval=[Benchmark1',Benchmark2']
```
- `--benchmark_train`  contains the benchmarks to train on.
- `--benchmark_eval` contains the benchmarks to evaluate on.

For example, if you want to train MaskRegulate on benchmark `superblue1`, `superblue3` and evaluate the performance on `superblue1`, `superblue3`, 'superblue5', run our command as shown bellow:
```
python main.py --benchmark_train=[superblue1,superblue3] --benchmark_eval=[superblue1,superblue3,superblue5]
```
We also provide a pre-trained model trained on superblue1, superblue3, superblue4 and superblue5 in `policy/pretrained_model.pkl`, which can be loaded and evaluated. For example, run the following command to test our policy on superblue1:
```
python main.py --benchmark_train=[] --benchmark_eval=[superblue1] --check_point_path=../policy/pretrained_model.pkl --eval_policy=True
```
Scripts `run_train.sh` and `run_test.sh` are provided for a quick start.