# Training instructions

* For training, please run the script in the directory `zy_runfiles/micro-auc-scripts/dataset_name`. The `dataset_name` is the corresponding dataset name you want to train on.

* The scripts mentioned above are like bash files for simplicity. An example script is as follows:

  ```
  micro_auc_1dataset_usage(
      dataset_name="voc",
      des="batch_learning1e-4",
      crit="u_2",
      measure='micro-auc',
      py_file="batch_learning.py",
      seed_list=[2222],
      epoch=40,
      batch_size=196,
      opt="sgd",
      cu=0,
      lr=0.001,
      weight_decay=1e-4,
      loss_mode="u_2"
  )
  ```

  The `des` is a brief description of training details.

* The root of the main training file is `examples/micro-auc/batch_learning.py`.

* The training results are saved in the directory `train_logs`.

# MLC Training
In MLC file, please run `python main.py --dataset emotions --mode u_2 --model Linear --weight_decay 1e-5`
