export function BinaryProjects(props: { projects: BinaryAnnotationData[] }) {
  return (
    <div class="flex flex-wrap gap-4 p-4 max-w-3xl mx-auto">
      <div class="prose dark:prose-invert">
        <h1 class="text-2xl font-bold text-center mb-6">
          Emotion Classification Tutorial
        </h1>

        <section class="mb-6">
          <h2 class="text-xl font-semibold mb-3">Instructions</h2>
          <p class="mb-4 text-left">
            In this task, you'll be assessing whether a specific emotion appears
            to be present in a face. Each face you see is generated by AI and
            does not resemble any real person. The goal of this study is to
            improve AI's ability to empathize by recognizing emotions in
            counseling, therapy, and social support settings.
          </p>
          <p class="mb-4 text-left">
            To help make these systems better at detecting emotions, your
            honest, uncensored, and spontaneous responses are essential.
          </p>
        </section>

        <section class="mb-6">
          <h2 class="text-xl font-semibold mb-3">Task Overview</h2>
          <p class="mb-4 text-left">
            You will be shown a face along with a list of emotions. For each
            emotion, your task is simply to decide Yes (emotion is present) or
            No (emotion is not present). This is not a precise science, so rely
            on your intuition and first impressions to make your decisions.
          </p>
          <p class="mb-4 text-left">
            Remember, emotion recognition is influenced by cultural and social
            factors and is therefore subjective. There are no "right" or "wrong"
            answers here — just your honest responses based on how you perceive
            the expressions in the faces.
          </p>
        </section>

        <section class="mb-6">
          <h2 class="text-xl font-semibold mb-3">Recommendations</h2>
          <ul class="list-disc pl-6 space-y-2 text-left">
            <li>
              <strong>Relax First:</strong>{" "}
              Close your eyes for a moment before starting a new image and take
              a few deep breaths. This can help you feel calm and improve your
              awareness of subtle facial cues.
            </li>
            <li>
              <strong>Observe & Decide:</strong>{" "}
              Look at the face and consider each emotion in turn. Ask yourself,
              "Does this person seem to be feeling this emotion right now?" Then
              answer Yes or No based on your gut feeling.
            </li>
            <li>
              <strong>Repeat & Submit:</strong>{" "}
              After answering for each emotion, click Submit and Proceed to move
              to the next image. Repeat the process with the same relaxed focus.
            </li>
            <li>
              <strong>Create a Calm Environment:</strong>{" "}
              Working in a calm space with minimal distractions, possibly with a
              tea or coffee, can make the task more enjoyable and enhance your
              intuition.
            </li>
          </ul>
        </section>

        <p class="text-center text-lg font-medium mt-6">
          Trust yourself and enjoy the process! 😊
        </p>
      </div>

      {props.projects?.map((item, index: number) => (
        index >= 18 && (
        <a
        href={`/binary/${item.name}`}
        class="rounded-md shadow-md p-4 text-black"
        >
          Part {item.name!.split("-").pop()}
        </a>)
      ))}
    </div>
  );
}
