from __future__ import division

import os
import argparse
import numpy as np

import torch

from utils.args import mind_parser
from tasks.mind import MIND
from utils.mypath import mypath

from itertools import product

import warnings

warnings.filterwarnings(action='ignore')


def my_product(inp):
    return (dict(zip(inp.keys(), values)) for values in product(*inp.values()))


def main(args: argparse, game_name: str = None, exp_num: int = None):
    # Define Save Path
    result_path = mypath(args, exp_num=exp_num)

    args.game = game_name.split('/')[-1].split('-')[0]
    xid = f'{args.game}-{str(args.seed)}'
    args.id = xid

    results_dir = os.path.join(result_path, args.game, args.id)

    if not os.path.exists(results_dir):
        os.makedirs(results_dir)

    np.random.seed(args.seed)
    torch.manual_seed(args.seed)
    torch.cuda.manual_seed(args.seed)
    torch.backends.cudnn.enabled = args.enable_cudnn

    mind = MIND(args, results_dir)
    mind.run_mind()


if __name__ == '__main__':
    parser = mind_parser()
    args = parser.parse_args()

    experiments = list(np.random.randint(10000, size=1))

    game_list = ['alien', 'assault', 'crazy_climber', 'frostbite',
                 'kung_fu_master', 'road_runner']

    for i, game in enumerate(game_list):

        args.train_mode = False
        args.seed = int(experiments[0])
        # Change Parameters
        args.ssl_option = 'multi_task'
        args.time_length = 6
        args.mask_scale = 0.33
        args.mask_ratio = 3.3
        args.depth = 2
        args.momentum = 0.999
        args.evaluate = True
        args.model = f'./MINDSampleResults/' \
                     f'{game}/mind_rainbow.pt'
        args.evaluation_episodes = 100

        main(args, game, exp_num=int(i + 1))
