from gym.envs.registration import registry, register, make, spec
from itertools import product

sizes = range(5, 20)
players = range(2, 20)
foods = range(1, 11)
coop = [True, False]
partial_obs = [True, False]

for s, p, f, c, po in product(sizes, players, foods, coop, partial_obs):
    register(
        id="Foraging{4}-{0}x{0}-{1}p-{2}f{3}-v2".format(s, p, f, "-coop" if c else "", "-2s" if po else ""),
        entry_point="lbforaging.foraging:ForagingEnv",
        kwargs={
            "players": p,
            "max_player_level": 4, # default: 2
            "field_size": (s, s),
            "max_food": f,
            "sight": 2 if po else s,
            "max_episode_steps": 200,
            "force_coop": c,
            "grid_observation": False,
        },
    )

register(
    id='lbf_spread_random-v0',
    entry_point='lbforaging.foraging:ForagingEnv',
    kwargs={
        "players": 2,
        "max_player_level": 4,
        "target_food_level": 'random',
        "field_size": (8, 8),
        "max_food": 8,
        "sight": 8,
        "max_episode_steps": 30,
        "force_coop": True,
        "grid_observation": False,
        "layout": "spread",
        "penalty": 0.0
    }
)
for level in range(1, 9):
    register(
        id=f'lbf_spread_{level}-v0',
        entry_point='lbforaging.foraging:ForagingEnv',
        kwargs={
            "players": 2,
            "max_player_level": 4,
            "target_food_level": level,
            "field_size": (8, 8),
            "max_food": 8,
            "sight": 8,
            "max_episode_steps": 30,
            "force_coop": True,
            "grid_observation": False,
            "layout": "spread",
            "penalty": 0.0
        }
    )


register(
    id='lbf_star-v0',
    entry_point='lbforaging.foraging:ForagingEnv',
    kwargs={
        "players": 2,
        "max_player_level": 4,
        "partner_level": 'random',
        "field_size": (9, 9),
        "max_food": 13,
        "sight": 9,
        "max_episode_steps": 100,
        "force_coop": True,
        "grid_observation": False,
        "layout": "star",
        "penalty": 0.01
    }
)
for partner in range(1, 5):
    register(
        id=f'lbf_star_{partner}-v0',
        entry_point='lbforaging.foraging:ForagingEnv',
        kwargs={
            "players": 2,
            "max_player_level": 4,
            "partner_level": partner,
            "field_size": (9, 9),
            "max_food": 13,
            "sight": 9,
            "max_episode_steps": 100,
            "force_coop": True,
            "grid_observation": False,
            "layout": "star",
            "penalty": 0.01
        }
    )

register(
    id='lbf_enclosure-v0',
    entry_point='lbforaging.foraging:ForagingEnv',
    kwargs={
        "players": 2,
        "max_player_level": 4,
        "field_size": (8, 8),
        "max_food": 8,
        "sight": 8,
        "max_episode_steps": 200,
        "force_coop": True,
        "grid_observation": False,
        "layout": "enclosure"
    }
)

def grid_registration():
    for s, p, f, c in product(sizes, players, foods, coop):
        for sight in [2, s]: #range(1, s + 1):
            register(
                id="Foraging-grid{4}-{0}x{0}-{1}p-{2}f{3}-v2".format(s, p, f, "-coop" if c else "", "" if sight == s else f"-{sight}s"),
                entry_point="lbforaging.foraging:ForagingEnv",
                kwargs={
                    "players": p,
                    "max_player_level": 2,
                    "field_size": (s, s),
                    "max_food": f,
                    "sight": sight,
                    "max_episode_steps": 50,
                    "force_coop": c,
                    "grid_observation": True,
                },
            )

register(
    id='LBFMultiEnv-v0',
    entry_point='lbforaging.lbf:LBFMultiEnv'
)