# Haland

This is the code for the paper "Haland: Human-AI Coordination via Policy Generation from Language-guided Diffusion".

Our work builds on the codebase of  https://github.com/Stanford-ILIAD/PantheonRL.

To run the experiment, please follow the installation instructions of the original codebase and then merge our files with it.

The environments used in our work includes:

1. Overcooked: We utilize the https://github.com/Stanford-ILIAD/PantheonRL environment wrapper.
2. LBF: https://github.com/semitable/lb-foraging
3. Assistive Gym: https://github.com/Healthcare-Robotics/assistive-gym

Follow the installation instructions in the respective repositories to set up the environments. Since we have modified some of the underlying code implementations in Overcooked, we are providing a series of patch files in the 'overcooked_patches' directory to replace the corresponding files. Similarly, we have made modifications to the LBF and Assistive Gym environments to ensure compatibility with the PantheonRL framework. To run the experiment, please install those environments and merge our files with them.

### Installation

```
conda create -n haland python=3.7
conda activate haland
pip install -r environment.yml
```

### Train diverse partners (and corresponding best responses)

```
bash scripts/train_diverse_partners_overcooked.sh
bash scripts/train_diverse_partners_lbf.sh
bash scripts/train_diverse_partners_assistive.sh
```

### Train modules of Haland

```
cd diffusion_human_ai
bash scripts/train_vae.sh
bash scripts/train_translator.sh
bash scripts/train_diffusion.sh
```

### Evaluate with diverse partners

```
cd diffusion_human_ai
bash scripts/evaluate_overcooked.sh
bash scripts/evaluate_lbf.sh
bash scripts/evaluate_assistive.sh
```