def text_summarization_undetectable_exp(output_path, ppl_save_path, score_save_path):
    from . import text_summarization as ts

    print("ts.get_output.undetectable_exp_pipeline()")
    ts.get_output.undetectable_exp_pipeline(output_path=output_path)

    print("ts.evaluate.undetectable_exp_pipeline()")
    ts.evaluate.undetectable_exp_pipeline(output_path=output_path,score_save_path=score_save_path)

    print("ts.evaluate_ppl.undetectable_exp_pipeline()")
    ts.evaluate_ppl.undetectable_exp_pipeline(output_path=output_path,ppl_save_path=ppl_save_path)

    print("finish text summarization.")


def text_generation_undetectable_exp(
    output_path,
    score_save_path,
):
    from . import text_generation as tg

    # print("tg.get_output.undetectable_exp_pipeline()")
    # tg.get_output.undetectable_exp_pipeline(output_path=output_path)

    print("tg.evaluate_beta_score.pipeline()")
    tg.evaluate_beta_score.pipeline(
        output_path=output_path, score_save_path=score_save_path
    )
    print("finish text generation.")


def add_watermark_exp():
    import argparse

    parser = argparse.ArgumentParser()

    # ts: text summarization; tg: text generation
    parser.add_argument("--exp_type", type=str, choices=["ts", "tg"])
    parser.add_argument(
        "--ts_output_path", type=str, default="ts_result/text_summarization.txt"
    )
    parser.add_argument(
        "--ts_ppl_save_path", type=str, default="ts_result/text_summarization_ppl.txt"
    )
    parser.add_argument(
        "--ts_score_save_path",
        type=str,
        default="ts_result/text_summarization_result.txt",
    )

    parser.add_argument(
        "--tg_output_path", type=str, default="tg_result/text_generation.txt"
    )
    parser.add_argument(
        "--tg_score_save_path", type=str, default="tg_result/sigmoid_new.txt"
    )
    args = parser.parse_args()

    if args.exp_type == "tg":
        text_generation_undetectable_exp(
            output_path=args.tg_output_path, score_save_path=args.tg_score_save_path
        )
    elif args.exp_type == "ts":
        text_summarization_undetectable_exp(
            output_path=args.ts_output_path,
            score_save_path=args.ts_score_save_path,
            ppl_save_path=args.ts_ppl_save_path,
        )
    else:
        print("Unknown exp_type.")
        raise NotImplementedError


if __name__ == "__main__":
    print("Add watermark experiment")
    add_watermark_exp()
