def undetectable_exp_pipeline(output_path):
    from .common import set_spawn

    set_spawn()

    from torch.multiprocessing import Process, Queue, Event

    from .common import get_num_gpus

    num_gpus = get_num_gpus()

    tq = Queue(maxsize=num_gpus)
    tqe = Event()
    rq = Queue()
    rqe = Event()

    from .common import batched_wp_task_worker, transformer_worker
    from . import get_in_ds_undetectable_exp

    task_worker_ = Process(
        target=batched_wp_task_worker,
        args=(tq,),
        kwargs={"get_in_ds": get_in_ds_undetectable_exp, "batch_size": 1},
    )
    gpu_workers = [
        Process(
            target=transformer_worker,
            args=(tq, tqe, rq, i),
            # kwargs={
            #     "model_str": "philschmid/bart-large-cnn-samsum",
            #     "generation_kwargs": {
            #         "max_length": 128,
            #         "temperature": 1,
            #     },
            # },
            kwargs={
                #  "model_str": "meta-llama/Llama-2-7b-chat-hf",
                "model_str": "models/llama-2-7b-chat-hf",
                "decoder_only": True,
                "generation_kwargs": {
                    "max_new_tokens": 512,
                    "temperature": 1.0,
                },
                "tokenization_kwargs": {
                    "task_template": "Help me complete the following text with at least 500 words:\n{input}",
                    "max_length": 3072,
                },
            },
        )
        for i in range(num_gpus)
    ]
    from .common import simple_store_worker

    store_worker = Process(
        target=simple_store_worker, args=(output_path, rq, rqe)
    )

    task_worker_.start()
    # exit(0)
    for w in gpu_workers:
        w.start()
    store_worker.start()

    task_worker_.join()
    assert task_worker_.exitcode == 0
    tqe.set()
    for w in gpu_workers:
        w.join()
        assert w.exitcode == 0
    rqe.set()
    store_worker.join()
    assert store_worker.exitcode == 0
