# explore


Here is a step-by-step process showing how to handle the data using various Python scripts:

1. **Process Raw Data**
   - Use `process.py` to process raw data and obtain readable data `f1` (save images, save readable data).

2. **Clickable and Visible Data Processing**
   - Use `collect_userful_ui_dataset.py` to process clickable and visible data from `f1` into `f2`.

3. **Annotate Clickable and Visible UI Icons**
   - Use `draw_box.py` to annotate clickable and visible UI icons in images based on `f1`.

4. **Process Simplified Version Data**
   - Use `collect_simple_androidcontrol_test.py` to process a simplified version data from `f2` into `f3`.

5. **Generate Episode Tree Dataset**
   - Use `gptInference_exploreBenchmark.py`, input `f3`, and generate episode tree dataset which is saved in `f4`.

6. **Process with GPT4o Instructions**
   - Use `collect_exploration_benchmark.py`'s `collect_gpt4o_instruction` function to process `f4` and obtain file `f5`.

7. **Obtain Width Dimension Data**
   - Use `collect_exploration_benchmark.py`'s `collect_wdith_benchmark` function to get qwen input data `f6`.

8. **Generate Correct Actions File**
   - Use `inference_golden_action_from_qwen.py`, input `f6`, and output a file containing correct actions `f7`.

8. **Obtain Width Dimension Data**
   - Use `collect_exploration_benchmark.py`'s `collect_Qwen2d5_action_answer` function to get width dimension data `f8`.

9. **Obtain Depth Dimension Data**
   - Use `collect_exploration_benchmark.py`'s `collect_depth_benchmark` function to get depth dimension data `f9`.

10. **Generate Correct Actions File**
   - Use `gptInference_correct_action.py`, input `f8`, and obtain file `f10`.

11. **Generate Correct Instructions File**
   - Use `gptInference_correct_instruction.py`, input `f9`, and obtain file `f11`.

12. **Filter Width Data**
   - Use the `collect_exploration_benchmark.py`'s `collect_width_benchmark_ValidatedData` function, input `f10`, and obtain filtered file `f12`.

13. **Filter Depth Data**
   - Use the `collect_exploration_benchmark.py`'s `collect_depth_benchmark_ValidatedData` function, input `f11`, and obtain filtered file `f13`.

With these steps, we achieve high-quality width and depth data represented by `f12` and `f13`.


14. Additionally, we can apply rule-based filtering to further refine the quality of the data (optional).
   - Use the `filter_width_data_by_rule.py`, input `f12`, and obtain filtered file `f14`